<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output version="4.0" method="html" indent="no" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:variable name="XML1" select="/"/>
	<xsl:decimal-format decimal-separator="," grouping-separator=" "/>
	<xsl:template match="/">
		<html>
			<head>
				<title/>
				<meta http-equiv="X-UA-Compatible" content="IE=5"/>
				<style type="text/css">
					@page { margin-left:0.6in;
					    margin-right:0.6in;
					    margin-top:0.79in;
					    margin-bottom:0.79in; }
					td { padding-top:1px;
					    padding-right:3px;
					    padding-bottom:1px;
					    padding-left:3px; }
					.h1 { background-color:#B0C4DE;
					    font-size:12pt;
					    font-weight:bold;
					    text-align:center; }
					.h2 { background-color:#E6E6FA;
					    font-size:9pt;
					    font-weight:bold;
					    text-align:center; }
					.h3 { background-color:#E6E6FA; }
					.h4 { background-color:#dad3f1; }
					table { border-collapse:collapse;
					    border-bottom:0;
					    border-left:0;
					    border-top:0;
					    border-right:0;
					    color:#191970;
					    font-size:8pt;
					    font-weight:400;
					    font-style:normal;
					    font-family:"Arial";
					    word-wrap:break-word; }
				</style>
			</head>
			<body>
				<xsl:variable name="varlang" select="RTS_DOC/REPORT/DOC_INFO/@ReportLang"/>
				<xsl:variable name="varversion" select="RTS_DOC/REPORT/DOC_INFO/@ReportVersion"/>
				<xsl:for-each select="$XML1">
					<xsl:for-each select="RTS_DOC">
						<div>
							<xsl:for-each select="DOC_REQUISITES">
								<table width="100%" style="background-color:#FFFAF0; color=#191970; font-size:11; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0;" border="1">
									<xsl:variable name="CurrContextGrid_3" select="."/>
									<tr style="text-align:center; vertical-align:Center; word-wrap:break-word; font-size:15; font-weight:bold; color:#191970; background-color: #B0C4DE;">
										<th colspan="7">
											<span>
												<xsl:value-of select="@SENDER_NAME"/>
											</span>
										</th>
									</tr>
									<tr style="background-color:#E6E6FA; text-align:center;">
										<td width="27%">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Документ</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Document</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="7%">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Тип</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Type</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="15%">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код ЭДО отправителя</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Sender's EDI code</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код ЭДО получателя</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Recipient's EDI code</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td rowspan="2" colspan="3" style="font-style:italic; text-align:left; vertical-align:top; background-color:#FFFAF0;">
											<span style="font-weight:bold;">
												<xsl:choose>
													<xsl:when test="$varlang='RU'">
														<xsl:text>Примечание:</xsl:text>
													</xsl:when>
													<xsl:when test="$varlang='EN'">
														<xsl:text>Notes to the document:</xsl:text>
													</xsl:when>
												</xsl:choose>
											</span>
											<xsl:for-each select="@REMARKS">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
									</tr>
									<tr style="text-align:center">
										<td>
											<xsl:for-each select="@DOC_NO">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text> от </xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text> of </xsl:text>
												</xsl:when>
											</xsl:choose>
											<xsl:for-each select="@DOC_DATE">
												<xsl:variable name="seqContentStrings_0">
													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
													<xsl:text>-</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
													<xsl:text>-</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
												</xsl:variable>
												<xsl:variable name="sContent_0" select="string($seqContentStrings_0)"/>
												<xsl:value-of select="$sContent_0"/>
											</xsl:for-each>
											<xsl:text/>
											<xsl:for-each select="@DOC_TIME">
												<xsl:text> </xsl:text>
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="@DOC_TYPE_ID">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="@SENDER_ID">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="@RECEIVER_ID">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
							<!-- DOC_REQUISITES -->
						</div>
						<xsl:for-each select="REPORT">
							<xsl:for-each select="DOC_INFO">
								<table width="100%" style="background-color:#FFFAF0; color:#191970; font-size:11; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0;" border="1">
									<th colspan="7" style="text-align:center; vertical-align:Center; word-wrap:break-word; font-size:15; font-weight:bold; color:#191970; background= #B0C4DE;">
										<xsl:choose>
											<xsl:when test="@ReportDesc!=''">
												<span>
													<xsl:value-of select="@ReportDesc"/>
												</span>
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$varlang='RU'">
														<xsl:text>Информация о договорах, заключенных Участником торгов за Торговый день</xsl:text>
													</xsl:when>
													<xsl:when test="$varlang='EN'">
														<xsl:text>Information about the contracts concluded by the Trade Member during the Trading Day</xsl:text>
													</xsl:when>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</th>
									<tr style="text-align:center;">
										<td width="17%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Дата отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report date:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="10%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report code:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="10%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Номер отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report number:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="10%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Том отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report volume:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="14%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код участника торгов:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Trade Member identifier:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td colspan="2" width="auto" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Наименование участника торгов:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Trade Member name:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
									</tr>
									<tr>
										<td style="text-align:center;">
											<xsl:for-each select="@ReportDate">
												<span>
													<xsl:variable name="seqContentStrings_1">
														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
														<xsl:text>-</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
														<xsl:text>-</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
													</xsl:variable>
													<xsl:variable name="sContent_1" select="string($seqContentStrings_1)"/>
													<xsl:value-of select="$sContent_1"/>
												</span>
											</xsl:for-each>
											<xsl:for-each select="@Weekday">
												<span>
													<xsl:text> (</xsl:text>
													<xsl:value-of select="string(.)"/>
													<xsl:text>)</xsl:text>
												</span>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@ReportCode">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@ReportNumber">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@Volume">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text> из </xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text> from </xsl:text>
												</xsl:when>
											</xsl:choose>
											<xsl:for-each select="@VolumeTotal">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@FirmId">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td colspan="2" style="text-align:center;">
											<xsl:for-each select="@FirmName">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
								<br/>
							</xsl:for-each>
							<!-- DOC_INFO -->
							<!-- Проверка на версионность, и разветвление на разные типы отчетов -->
							<xsl:choose>
								<xsl:when test="$varversion=1 or $varversion=''">
									<xsl:for-each select="CLRACC">
										<xsl:for-each select="SUBCLRACC">
											<table width="50%" style="background=#CFCED9; color=#191970; font-size:11; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0;" border="1">
												<tr>
													<td width="30%" style="background-color:#E6FFFF;">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Код ТКС:</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>TCA Code:</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="20%" style="font-weight:bold;">
														<xsl:for-each select="../@ClrAccCode">
															<xsl:value-of select="string(.)"/>
														</xsl:for-each>
													</td>
													<td width="30%" style="background-color:#E6FFFF;">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Код подраздела ТКС:</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>Code of TCA subsection:</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="20%" style="font-weight:bold;">
														<xsl:for-each select="@SubClrAccCode">
															<xsl:value-of select="string(.)"/>
														</xsl:for-each>
													</td>
												</tr>
											</table>
											<br/>
											<xsl:for-each select="CURRENCY">
												<xsl:for-each select="BOARD">
													<xsl:for-each select="SETTLEDATE">
														<table width="100%" style="background=#CFCED9; color=#191970; font-size:11; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0;" border="1">
															<tr>
																<td width="15%" style="background-color:#E6E6FA;">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Валюта цены:</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Price currency:</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</td>
																<td width="15%">
																	<xsl:for-each select="../../@CurrencyId">
																		<xsl:value-of select="string(.) "/>
																	</xsl:for-each>
																	<xsl:for-each select="../../@CurrencyName">
																		<xsl:text> (</xsl:text>
																		<xsl:value-of select="string(.)"/>
																		<xsl:text>)</xsl:text>
																	</xsl:for-each>
																</td>
																<td width="30%" style="font-weight:bold; background= #CFCED9; color=#191970; text-align:center">
																	<xsl:for-each select="../@BoardName">
																		<xsl:value-of select="string(.) "/>
																	</xsl:for-each>
																	<td width="10%" style="background-color:#E6E6FA;">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Дата расчета:</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Calculation date:</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</td>
																	<td>
																		<xsl:for-each select="@SettleDate">
																			<xsl:variable name="seqContentStrings_2">
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																				<xsl:text>-</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																				<xsl:text>-</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			</xsl:variable>
																			<xsl:variable name="sContent_2" select="string($seqContentStrings_2)"/>
																			<xsl:value-of select="$sContent_2"/>
																		</xsl:for-each>
																	</td>
																</td>
															</tr>
														</table>
														<br/>
														<table width="100%" style="background=#FFFAF0; color=#191970; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0; border-top:0; font-family:Arial; font-size:9; word-wrap:break-word;" border="1">
															<thead style="text-align:center; word-wrap:break-word; ">
																<tr style="text-align:center; vertical-align:top; word-wrap:break-word; color:#191970; background-color:#E6E6FA;">
																	<th width="2%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>№ п/п</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>No. in ord.</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Номер дог.</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Contract number</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Дата рег. дог.</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Date of registr. of the agreem.</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Время рег. дог.</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Time of contract registr.</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Торг. период</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Trading period</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Особый торг. период</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Special trading period</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Тип заявки</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Type of request</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Логин</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Login</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Напр.</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Dir.</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Тип дог.</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Type of agreement</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Тип инстр.</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>type of instrument</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Наим. режима торгов</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Name of the trading mode</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Цена за ед. инстр.</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>price per unit of the toolkit</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Объем договора, в инстр.</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Quantity of instrum. in the contract</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="4%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Объем договора, </xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Volue of contract, </xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text>(</xsl:text>
																			<xsl:value-of select="../../@CurrencyId"/>
																			<xsl:text>)</xsl:text>
																		</span>
																	</th>
																	<th width="4%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Обяз-во по ден. ср-вам, </xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Cash commitment, </xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text>(</xsl:text>
																			<xsl:value-of select="../../@CurrencyId"/>
																			<xsl:text>)</xsl:text>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Обяз-во по ЦБ</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Obligation on securities</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Биржевая комиссия </xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>stock market fee</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text>(</xsl:text>
																			<xsl:value-of select="../../@CurrencyId"/>
																			<xsl:text>)</xsl:text>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Клиринговая комиссия </xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Clearing fee</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text>(</xsl:text>
																			<xsl:value-of select="../../@CurrencyId"/>
																			<xsl:text>)</xsl:text>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Гербовый сбор </xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Stamp duty</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text>(</xsl:text>
																			<xsl:value-of select="../../@CurrencyId"/>
																			<xsl:text>)</xsl:text>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>ИНН или № пасп. клиента</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>ITN or passport number of the client</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Код ЦК</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>CC code</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>ID адр. сд. УТ подавш. заявку</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>ID of the addr. deal TM who submitt Applic.</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>ID адр. сд. УТ принявш. заявку</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>ID of the addr. deal TM who accepted Applic.</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Кр. код клиента</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>The short code of the client</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="4%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>НКД </xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Accumul. coupon income</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text>(</xsl:text>
																			<xsl:value-of select="../../@CurrencyId"/>
																			<xsl:text>)</xsl:text>
																		</span>
																	</th>
																	<th width="4%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Цена 2 ч. репо</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Price of repo part 2</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Ставка репо</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Repo rate</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Часть репо</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Part of the repo</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th width="3%">
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Срок репо</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Repo period</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th>
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>ID режима торгов в Торговой системе</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Trading mode ID in Trading system</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																	<th>
																		<span style="font-weight:bold; text-align:center; ">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Официальная дата торгов</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Official trading date</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																		</span>
																	</th>
																</tr>
															</thead>
															<tbody>
																<xsl:for-each select="SECURITY">
																	<tr style="height:21px; vertical-align:top; background-color:#FFFAF0;">
																		<td colspan="32" style="font:9; font-weight:bold; text-align:left; vertical-align:middle; background= #CFCED9;" border="1">
																			<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
																			<xsl:value-of select="../@BoardID"/>
																			<xsl:value-of select="../@BoardName"/>
																			<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																			<xsl:for-each select="@SecurityId">
																				<xsl:value-of select="string(.)"/>
																			</xsl:for-each>
																			<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
																			<xsl:text>(</xsl:text>
																			<xsl:for-each select="@ISIN">
																				<xsl:value-of select="string(.)"/>
																			</xsl:for-each>
																			<xsl:text>)</xsl:text>
																			<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																			<xsl:for-each select="@SecShortName">
																				<xsl:value-of select="string(.)"/>
																			</xsl:for-each>
																			<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																			<xsl:for-each select="@RegNumber">
																				<xsl:value-of select="string(.)"/>
																			</xsl:for-each>
																			<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Номинал: </xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Nominal value: </xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<span>
																				<xsl:variable name="rab_var" select="string(@FaceValue)"/>
																				<xsl:variable name="rab_var1">
																					<xsl:choose>
																						<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																							<xsl:text>0.0</xsl:text>
																						</xsl:when>
																						<xsl:when test="contains($rab_var, '.')=false">
																							<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																						</xsl:when>
																						<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																							<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																						</xsl:when>
																						<xsl:otherwise>
																							<xsl:value-of select="string($rab_var)"/>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:variable>
																				<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																				<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																				<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																			</span>
																			<xsl:text> (</xsl:text>
																			<xsl:for-each select="@SecCurrencyId">
																				<xsl:value-of select="string(.)"/>
																			</xsl:for-each>
																			<xsl:text>)</xsl:text>
																			<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																			<xsl:text>(</xsl:text>
																			<xsl:choose>
																				<xsl:when test="@PriceType = 'PERC'">
																					<xsl:choose>
																						<xsl:when test="$varlang='RU'">
																							<xsl:text>цена указана в % от номинала</xsl:text>
																						</xsl:when>
																						<xsl:when test="$varlang='EN'">
																							<xsl:text>Price is indicated in % nominal</xsl:text>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:choose>
																						<xsl:when test="$varlang='RU'">
																							<xsl:text>цена указана в </xsl:text>
																						</xsl:when>
																						<xsl:when test="$varlang='EN'">
																							<xsl:text>Price is indicated in </xsl:text>
																						</xsl:when>
																					</xsl:choose>
																					<xsl:value-of select="../../../@CurrencyId"/>
																				</xsl:otherwise>
																			</xsl:choose>
																			<xsl:text>)</xsl:text>
																		</td>
																	</tr>
																	<xsl:for-each select="RECORDS">
																		<tr style="vertical-align:top; ">
																			<td style="text-align:right; ">
																				<xsl:for-each select="@RecNo">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:center; width:auto; ">
																				<xsl:for-each select="@TradeNo">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:for-each select="@TradeDate">
																					<xsl:variable name="seqContentStrings_4">
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																						<xsl:text>.</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																						<xsl:text>.</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																					</xsl:variable>
																					<xsl:variable name="sContent_4" select="string($seqContentStrings_4)"/>
																					<xsl:value-of select="$sContent_4"/>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:center; ">
																				<xsl:for-each select="@TradeTime">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:center; ">
																				<xsl:choose>
																					<xsl:when test="$varlang='RU'">
																						<xsl:choose>
																							<xsl:when test="@TradePeriod='MAIN'">
																								<xsl:text>основной</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradePeriod='EVE'">
																								<xsl:text>дополнительный</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradePeriod='CLOSE'">
																								<xsl:text>аукцион закрытия</xsl:text>
																							</xsl:when>
																						</xsl:choose>
																					</xsl:when>
																					<xsl:when test="$varlang='EN'">
																						<xsl:choose>
																							<xsl:when test="@TradePeriod='MAIN'">
																								<xsl:text>main</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradePeriod='EVE'">
																								<xsl:text>additional</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradePeriod='CLOSE'">
																								<xsl:text>closing auction</xsl:text>
																							</xsl:when>
																						</xsl:choose>
																					</xsl:when>
																				</xsl:choose>
																			</td>
																			<td style="text-align:center; ">
																				<xsl:for-each select="@SpecialPeriod">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:center; ">
																				<xsl:choose>
																					<xsl:when test="$varlang='RU'">
																						<xsl:choose>
																							<xsl:when test="@OrderType='1'">
																								<xsl:text>рыночная</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='2'">
																								<xsl:text>лимитная</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='103'">
																								<xsl:text>адресная</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='104'">
																								<xsl:text>дополнит. ликвидности</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='123'">
																								<xsl:text>аукциона закрытия</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='124'">
																								<xsl:text>оффсетная</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='125'">
																								<xsl:text>котировочная</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='126'">
																								<xsl:text>не котировочная</xsl:text>
																							</xsl:when>
																						</xsl:choose>
																					</xsl:when>
																					<xsl:when test="$varlang='EN'">
																						<xsl:choose>
																							<xsl:when test="@OrderType='1'">
																								<xsl:text>market</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='2'">
																								<xsl:text>limited</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='103'">
																								<xsl:text>Negotiated</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='104'">
																								<xsl:text>Additional Liquidity</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='123'">
																								<xsl:text>Closing Auction</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='124'">
																								<xsl:text>Offset</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='125'">
																								<xsl:text>Quotation</xsl:text>
																							</xsl:when>
																							<xsl:when test="@OrderType='126'">
																								<xsl:text>Non-Quotation</xsl:text>
																							</xsl:when>
																						</xsl:choose>
																					</xsl:when>
																				</xsl:choose>
																			</td>
																			<td style="text-align:center; ">
																				<xsl:for-each select="@UserId">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:center; ">
																				<xsl:for-each select="@BuySell">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:choose>
																					<xsl:when test="$varlang='RU'">
																						<xsl:choose>
																							<xsl:when test="@TradeType = 'T'">
																								<xsl:text>безадр.</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeType = 'N'">
																								<xsl:text>адресн.</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeType = 'D'">
																								<xsl:text>без заявки</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeType = 'O'">
																								<xsl:text>внебиржевой (оферты ОТС тип 1)</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeType = 'P'">
																								<xsl:text>внебиржевой (оферты ОТС тип 2)</xsl:text>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:text/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:when>
																					<xsl:when test="$varlang='EN'">
																						<xsl:choose>
																							<xsl:when test="@TradeType = 'T'">
																								<xsl:text>unaddress</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeType = 'N'">
																								<xsl:text>address</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeType = 'D'">
																								<xsl:text>without request</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeType = 'O'">
																								<xsl:text>OTC contract with Type 1 OTC Offer</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeType = 'P'">
																								<xsl:text>OTC contract with Type 2 OTC Offer</xsl:text>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:text/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:when>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:choose>
																					<xsl:when test="$varlang='RU'">
																						<xsl:choose>
																							<xsl:when test="@TradeInstrumentType='1'">
																								<xsl:text>фьючерсные инструменты</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeInstrumentType='2'">
																								<xsl:text>опционы</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeInstrumentType='3'">
																								<xsl:text>инструменты с частичным обеспечением</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeInstrumentType='4'">
																								<xsl:text>РЕПО</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeInstrumentType='5'">
																								<xsl:text>связанные договора купли-продажи валюты</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeInstrumentType='9'">
																								<xsl:text>инструменты с полным обеспечением.</xsl:text>
																							</xsl:when>
																						</xsl:choose>
																					</xsl:when>
																					<xsl:when test="$varlang='EN'">
																						<xsl:choose>
																							<xsl:when test="@TradeInstrumentType='1'">
																								<xsl:text>futures instruments</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeInstrumentType='2'">
																								<xsl:text>options</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeInstrumentType='3'">
																								<xsl:text>tools with partially collateral</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeInstrumentType='4'">
																								<xsl:text>REPO</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeInstrumentType='5'">
																								<xsl:text>related currency bye-sale contracts</xsl:text>
																							</xsl:when>
																							<xsl:when test="@TradeInstrumentType='9'">
																								<xsl:text>tools with full collateral</xsl:text>
																							</xsl:when>
																						</xsl:choose>
																					</xsl:when>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:for-each select="@TradeModeName">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:for-each select="@Price">
																					<xsl:choose>
																						<xsl:when test="../@Decimals  = 0">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0')"/>
																						</xsl:when>
																						<xsl:when test="../@Decimals  = 1">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,0')"/>
																						</xsl:when>
																						<xsl:when test="../@Decimals  = 2">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																						</xsl:when>
																						<xsl:when test="../@Decimals  = 3">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,00#')"/>
																						</xsl:when>
																						<xsl:when test="../@Decimals  = 4">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,00##')"/>
																						</xsl:when>
																						<xsl:when test="../@Decimals  = 5">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,00###')"/>
																						</xsl:when>
																						<xsl:when test="../@Decimals  = 6">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,00#####')"/>
																						</xsl:when>
																						<xsl:when test="../@Decimals  = 7">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,00######')"/>
																						</xsl:when>
																						<xsl:otherwise>
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,00######')"/>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@Quantity)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@Value)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@Amount)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@Balance)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@ExchComm)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@ClrComm)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@StampDuty)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td>
																				<xsl:for-each select="@ClientDetails">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:for-each select="@CcpCode">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:center; " nowrap="set">
																				<xsl:for-each select="@OtcCodeInitiator">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:center; ">
																				<xsl:for-each select="@OtcCodeConfirmator">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td style="text-align:center; ">
																				<xsl:for-each select="@ClientCode">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td>
																				<span>
																					<xsl:variable name="rab_var" select="string(@AccInt)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:for-each select="@Price2">
																					<xsl:choose>
																						<xsl:when test="../@Decimals  = 0">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0')"/>
																						</xsl:when>
																						<xsl:when test="../@Decimals  = 1">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,0')"/>
																						</xsl:when>
																						<xsl:when test="../@Decimals  = 2">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																						</xsl:when>
																						<xsl:when test="../@Decimals  = 3">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,00#')"/>
																						</xsl:when>
																						<xsl:when test="../@Decimals  = 4">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,00##')"/>
																						</xsl:when>
																						<xsl:when test="../@Decimals  = 5">
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,00###')"/>
																						</xsl:when>
																						<xsl:otherwise>
																							<xsl:value-of select="format-number(number(string(.)), '# ##0,00######')"/>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</td>
																			<td>
																				<span>
																					<xsl:variable name="rab_var" select="string(@RepoRate)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td>
																				<xsl:for-each select="@RepoPart">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td>
																				<xsl:for-each select="@RepoPeriod">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td>
																				<xsl:for-each select="@InternalTradeModeId">
																					<xsl:value-of select="string(.)"/>
																				</xsl:for-each>
																			</td>
																			<td>
																				<xsl:for-each select="@TradeDateOfficial">
																					<xsl:variable name="seqContentStrings_4">
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																						<xsl:text>.</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																						<xsl:text>.</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																					</xsl:variable>
																					<xsl:variable name="sContent_4" select="string($seqContentStrings_4)"/>
																					<xsl:value-of select="$sContent_4"/>
																				</xsl:for-each>
																			</td>
																		</tr>
																		<xsl:choose>
																			<xsl:when test="@Type != 0">
																				<tr style="text-align:left; vertical-align:top; font-size:9pt; word-wrap:break-word; color:#191970; ">
																					<td colspan="31" style="width:auto; background=#E6E6FA; border-top:0">
																						<xsl:choose>
																							<xsl:when test="$varlang='RU'">
																								<xsl:text>Тип договора, заключенного в целях урегулирования неисполнения обязательств и в целях исполнения обязательств по договорам: </xsl:text>
																							</xsl:when>
																							<xsl:when test="$varlang='EN'">
																								<xsl:text>Type of contract concluded for purposes settling non-fulfillment of obligations and for purpose fulfilling obligations under contracts: </xsl:text>
																							</xsl:when>
																						</xsl:choose>
																						<span style="font-weight:bold;">
																							<xsl:choose>
																								<xsl:when test="$varlang='RU'">
																									<xsl:choose>
																										<xsl:when test="@Type = 1">
																											<xsl:text>Договор репо в случае неисполнения обязательств Участником торгов</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type = 2">
																											<xsl:text>ДКП в случае неисполнения обязательств Участником торгов</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type = 3">
																											<xsl:text>Договор репо в случае неисполнения обязательств Клиринговым центром</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type = 4">
																											<xsl:text>ДКП в случае неисполнения обязательств Клиринговым центром</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type = 5">
																											<xsl:text>Договор репо, заключенный Клиринговым центром с целью привлечения активов для урегулирования неисполнения обязательств</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type  = 6">
																											<xsl:text>ДКП, заключенный Клиринговым центром с целью принудительного закрытия позиции Участника торгов</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type  = 7">
																											<xsl:text>ДКП, заключенный в целях исполнения обязательств (договор, заключаемый в целях переноса позиции на другого организатора торгов)</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type  = 8">
																											<xsl:text>Договор, заключенный в целях закрытия позиции в результате исполнения поставочного/расчетного фьючерсного контракта</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type  = 9">
																											<xsl:text>Договор, заключенный в результате исполнения опционного контракта</xsl:text>
																										</xsl:when>
																										<xsl:otherwise>
																											<xsl:text/>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:when>
																								<xsl:when test="$varlang='EN'">
																									<xsl:choose>
																										<xsl:when test="@Type = 1">
																											<xsl:text>Repurchase Agreement in case of default of a Trading Member</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type = 2">
																											<xsl:text>Sale and purchase agreement in case of default of a Trading Member</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type = 3">
																											<xsl:text>Repurchase Agreement in case of Clearing Organisation default</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type = 4">
																											<xsl:text> Sale and purchase agreement in case of Clearing Organisation default</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type = 5">
																											<xsl:text> Repurchase Agreement concluded by Clearing Organisation to raise assets for default settlement</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type  = 6">
																											<xsl:text> Sale and purchase agreement concluded by Clearing Organisation to forcedly close position of a Trading Member</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type  = 7">
																											<xsl:text>Sale and purchase agreement concluded to fulfil obligations (Agreement concluded to transfer position to another trading operator)</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type  = 8">
																											<xsl:text>Agreement concluded for purposes of closing a position as result of execution of  supply/settlements futures contract</xsl:text>
																										</xsl:when>
																										<xsl:when test="@Type  = 9">
																											<xsl:text> Agreement concluded as a result of option contract fulfilment</xsl:text>
																										</xsl:when>
																										<xsl:otherwise>
																											<xsl:text/>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:when>
																							</xsl:choose>
																						</span>
																					</td>
																				</tr>
																			</xsl:when>
																		</xsl:choose>
																	</xsl:for-each>
																	<!-- RECORDS -->
																</xsl:for-each>
																<!-- SETTLEDATE -->
															</tbody>
														</table>
														<br/>
													</xsl:for-each>
													<!-- SETTLEDATE -->
												</xsl:for-each>
												<!-- BOARD -->
											</xsl:for-each>
											<!-- CURRENCY -->
										</xsl:for-each>
										<!-- SUBCLRACC -->
									</xsl:for-each>
									<!-- CLRACC -->
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>  Другая версия отчета</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
						<!-- REPORT -->
					</xsl:for-each>
					<!-- RTS_DOC -->
				</xsl:for-each>
				<!-- $XML1 -->
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
