<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output version="4.0" method="html" indent="no" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:variable name="XML1" select="/"/>
	<xsl:decimal-format decimal-separator="," grouping-separator=" "/>
	<xsl:template match="/">
		<html>
			<head>
				<title/>
				<meta http-equiv="X-UA-Compatible" content="IE=5"/>
				<style type="text/css">
					@page { margin-left:0.6in;
					    margin-right:0.6in;
					    margin-top:0.79in;
					    margin-bottom:0.79in; }
					td { padding-top:1px;
					    padding-right:3px;
					    padding-bottom:1px;
					    padding-left:3px; }
					.h1 { background-color:#B0C4DE;
					    font-size:12pt;
					    font-weight:bold;
					    text-align:center; }
					.h2 { background-color:#E6E6FA;
					    font-size:9pt;
					    font-weight:bold;
					    text-align:center; }
					.h3 { background-color:#E6E6FA; }
					.h4 { background-color:#dad3f1; }
					table { border-collapse:collapse;
					    border-bottom:0;
					    border-left:0;
					    border-top:0;
					    border-right:0;
					    background-color:#FFFAF0;
					    color:#191970;
					    font-size:8pt;
					    font-weight:400;
					    font-style:normal;
					    font-family:"Arial";
					    word-wrap:break-word; }
				</style>
			</head>
			<body>
				<xsl:variable name="varlang" select="RTS_DOC/REPORT/DOC_INFO/@ReportLang"/>
				<xsl:variable name="varversion" select="RTS_DOC/REPORT/DOC_INFO/@ReportVersion"/>
				<xsl:for-each select="$XML1">
					<xsl:for-each select="RTS_DOC">
						<div>
							<xsl:for-each select="DOC_REQUISITES">
								<table width="100%" style="background-color:#FFFAF0; color=#191970; font-size:11; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0;" border="1">
									<xsl:variable name="CurrContextGrid_3" select="."/>
									<tr style="text-align:center; vertical-align:Center; word-wrap:break-word; font-size:15; font-weight:bold; color:#191970; background-color: #B0C4DE;">
										<th colspan="5">
											<span>
												<xsl:value-of select="@SENDER_NAME"/>
											</span>
										</th>
									</tr>
									<tr style="background-color:#E6E6FA; text-align:center;">
										<td width="27%">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Документ</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Document</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="7%">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Тип</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Type</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="15%">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код ЭДО отправителя</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Sender's EDI code</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код ЭДО получателя</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Recipient's EDI code</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td rowspan="2" style="font-style:italic; text-align:left; vertical-align:top; background-color:#FFFAF0;">
											<span style="font-weight:bold;">
												<xsl:choose>
													<xsl:when test="$varlang='RU'">
														<xsl:text>Примечание:</xsl:text>
													</xsl:when>
													<xsl:when test="$varlang='EN'">
														<xsl:text>Notes to the document:</xsl:text>
													</xsl:when>
												</xsl:choose>
											</span>
											<xsl:for-each select="@REMARKS">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
									</tr>
									<tr style="text-align:center">
										<td>
											<xsl:for-each select="@DOC_NO">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text> от </xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text> of </xsl:text>
												</xsl:when>
											</xsl:choose>
											<xsl:for-each select="@DOC_DATE">
												<xsl:variable name="seqContentStrings_0">
													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
													<xsl:text>-</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
													<xsl:text>-</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
												</xsl:variable>
												<xsl:variable name="sContent_0" select="string($seqContentStrings_0)"/>
												<xsl:value-of select="$sContent_0"/>
											</xsl:for-each>
											<xsl:text/>
											<xsl:for-each select="@DOC_TIME">
												<xsl:text> </xsl:text>
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="@DOC_TYPE_ID">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="@SENDER_ID">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="@RECEIVER_ID">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
							<!-- DOC_REQUISITES -->
						</div>
						<xsl:for-each select="REPORT">
							<xsl:for-each select="DOC_INFO">
								<table width="100%" style="background-color:#FFFAF0; color:#191970; font-size:11; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0;" border="1">
									<th colspan="5" style="text-align:center; vertical-align:Center; word-wrap:break-word; font-size:15; font-weight:bold; color:#191970; background= #B0C4DE;">
										<xsl:choose>
											<xsl:when test="@ReportDesc!=''">
												<span>
													<xsl:value-of select="@ReportDesc"/>
												</span>
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$varlang='RU'">
														<xsl:text>Биржевая информация об итогах Торгов за Торговый день</xsl:text>
													</xsl:when>
													<xsl:when test="$varlang='EN'">
														<xsl:text>Stock exchange information on trading results for the Trading Day</xsl:text>
													</xsl:when>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</th>
									<tr style="text-align:center;">
										<td width="17%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Дата отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report date:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="10%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report code:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="10%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Номер отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report number:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="10%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Том отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report volume:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
									</tr>
									<tr>
										<td style="text-align:center;">
											<xsl:for-each select="@TradeDate">
												<span>
													<xsl:variable name="seqContentStrings_1">
														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
														<xsl:text>-</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
														<xsl:text>-</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
													</xsl:variable>
													<xsl:variable name="sContent_1" select="string($seqContentStrings_1)"/>
													<xsl:value-of select="$sContent_1"/>
												</span>
											</xsl:for-each>
											<xsl:for-each select="@Weekday">
												<span>
													<xsl:text> (</xsl:text>
													<xsl:value-of select="string(.)"/>
													<xsl:text>)</xsl:text>
												</span>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@ReportCode">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@ReportNumber">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@Volume">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text> из </xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text> of </xsl:text>
												</xsl:when>
											</xsl:choose>
											<xsl:for-each select="@VolumeTotal">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
								<br/>
							</xsl:for-each>
							<!-- DOC_INFO -->
							<!--Проверка на версионность, и разветвление на разные типы отчетов -->
							<xsl:choose>
								<xsl:when test="$varversion=1">
									<xsl:for-each select="BOARD">
										<table width="100%" style="background=#FFFAF0; color=#191970; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0; border-top:0; font-family:Arial; font-size:9; word-wrap:break-word;" border="1">
											<thead style="text-align:center; word-wrap:break-word; ">
												<tr>
													<th colspan="20" style="text-align:center; font-size=12; font-weight:bold; background=#E6E6FA; color=#191970;">
														<xsl:value-of select="@BoardId"/>
														<xsl:text> - </xsl:text>
														<xsl:value-of select="@BoardName"/>
														<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
													</th>
												</tr>
												<tr>
													<th colspan="20" style="text-align:center; font-size=11; font-weight:bold; background=#E6E6FA; color=#191970;">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Официальные итоги торгов</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>Official results of trading</xsl:text>
															</xsl:when>
														</xsl:choose>
													</th>
												</tr>
												<tr style="text-align:left; vertical-align:top; word-wrap:break-word; color:#191970; background=#E6E6FA;">
													<th width="4%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Код ЦБ</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Security code</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="9">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Краткое наименование ЦБ</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Short name of the security</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="2%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Валюта цены</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Price currency</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Общий объем в шт. инстр.</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Total volume in units of instruments</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Общий объем в валюте инстр.</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Total volume in currency of instruments</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Общее число сделок</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>The total number of deal</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>MIN цена сделки за день</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>MIN deal price for day</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>MAX цена сделки за день</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>MAX deal price for day</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Цена закрытия</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Closing price</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Цена закрытия пред. дня</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Previous day closing price</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Изменение цены закрытия, %</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Change in closing price, %</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Средневзв. цена за день</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Average weight. price for day</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Последняя текущ. цена за день</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Last current price for day</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:text></xsl:text>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Признаваемая котировка (ПК)</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Accepted Quotation (AQ)</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Объем дог. для расч. ПК</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Volume of contract for calculate AQ</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>РЦ2</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Estimated price 2 (EP2)</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Объем дог. для расч. РЦ2</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Volume of contract for calculate EP2</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>РЦ3</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Estimated price 3 (EP3)</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Объем дог. для расч. РЦ3</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Volume of contract for calculate EP3</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th width="5%">
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Цена клиринга</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Clearing price</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
												</tr>
											</thead>
											<tbody>
												<xsl:for-each select="SECURITY">
													<xsl:for-each select="RESULT">
														<tr style="vertical-align:top; background-color:#FFFFFF;">
															<td style="text-align:left; ">
																<xsl:for-each select="../@SecurityId">
																	<xsl:value-of select="string(.)"/>
																</xsl:for-each>
															</td>
															<td style="text-align:left; width:auto;">
																<xsl:for-each select="../@SecShortName">
																	<xsl:value-of select="string(.)"/>
																</xsl:for-each>
															</td>
															<td style="text-align:center;">
																<xsl:for-each select="../@CurrencyId">
																	<xsl:value-of select="string(.)"/>
																</xsl:for-each>
															</td>
															<td style="text-align:right; ">
																<span>
																	<xsl:variable name="rab_var" select="string(@TotalAmount)"/>
																	<xsl:variable name="rab_var1">
																		<xsl:choose>
																			<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																				<xsl:text>0.0</xsl:text>
																			</xsl:when>
																			<xsl:when test="contains($rab_var, '.')=false">
																				<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																			</xsl:when>
																			<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																				<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="string($rab_var)"/>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:variable>
																	<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																	<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																	<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																</span>
															</td>
															<td style="text-align:right; ">
																<span>
																	<xsl:variable name="rab_var" select="string(@TotalVolume)"/>
																	<xsl:variable name="rab_var1">
																		<xsl:choose>
																			<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																				<xsl:text>0.0</xsl:text>
																			</xsl:when>
																			<xsl:when test="contains($rab_var, '.')=false">
																				<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																			</xsl:when>
																			<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																				<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="string($rab_var)"/>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:variable>
																	<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																	<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																	<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																</span>
															</td>
															<td style="text-align:right; ">
																<xsl:for-each select="@TotalDealCount">
																	<xsl:value-of select="format-number(number(string(.)), '# ##0')"/>
																</xsl:for-each>
															</td>
															<td style="text-align:right; ">
																<xsl:choose>
																	<xsl:when test="../@Decimals=3">
																		<xsl:for-each select="@MinDealPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=4">
																		<xsl:for-each select="@MinDealPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=5">
																		<xsl:for-each select="@MinDealPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=6">
																		<xsl:for-each select="@MinDealPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:for-each select="@MinDealPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<td style="text-align:right; ">
																<xsl:choose>
																	<xsl:when test="../@Decimals=3">
																		<xsl:for-each select="@MaxDealPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=4">
																		<xsl:for-each select="@MaxDealPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=5">
																		<xsl:for-each select="@MaxDealPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=6">
																		<xsl:for-each select="@MaxDealPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:for-each select="@MaxDealPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<td style="text-align:right; ">
																<xsl:choose>
																	<xsl:when test="../@Decimals=3">
																		<xsl:for-each select="@ClosePrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=4">
																		<xsl:for-each select="@ClosePrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=5">
																		<xsl:for-each select="@ClosePrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=6">
																		<xsl:for-each select="@ClosePrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:for-each select="@ClosePrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<td style="text-align:right; width:auto; ">
																<xsl:choose>
																	<xsl:when test="../@Decimals=3">
																		<xsl:for-each select="@PrevClose">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=4">
																		<xsl:for-each select="@PrevClose">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=5">
																		<xsl:for-each select="@PrevClose">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=6">
																		<xsl:for-each select="@PrevClose">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:for-each select="@PrevClose">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<td style="text-align:right; width:auto; ">
																<xsl:choose>
																	<xsl:when test="../@Decimals=3">
																		<xsl:for-each select="@TrendClose">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=4">
																		<xsl:for-each select="@TrendClose">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=5">
																		<xsl:for-each select="@TrendClose">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=6">
																		<xsl:for-each select="@TrendClose">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:for-each select="@TrendClose">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<td style="text-align:right; ">
																<xsl:choose>
																	<xsl:when test="../@Decimals=3">
																		<xsl:for-each select="@WAPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=4">
																		<xsl:for-each select="@WAPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=5">
																		<xsl:for-each select="@WAPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=6">
																		<xsl:for-each select="@WAPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:for-each select="@WAPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<td style="text-align:right; ">
																<xsl:choose>
																	<xsl:when test="../@Decimals=3">
																		<xsl:for-each select="@CurrentPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=4">
																		<xsl:for-each select="@CurrentPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=5">
																		<xsl:for-each select="@CurrentPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=6">
																		<xsl:for-each select="@CurrentPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:for-each select="@CurrentPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<td style="text-align:right; ">
																<xsl:choose>
																	<xsl:when test="../@Decimals=3">
																		<xsl:for-each select="@AdmittedQuote">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=4">
																		<xsl:for-each select="@AdmittedQuote">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=5">
																		<xsl:for-each select="@AdmittedQuote">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=6">
																		<xsl:for-each select="@AdmittedQuote">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:for-each select="@AdmittedQuote">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<td style="text-align:right; ">
																<span>
																	<xsl:variable name="rab_var" select="string(@AdmittedQuoteVolume)"/>
																	<xsl:variable name="rab_var1">
																		<xsl:choose>
																			<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																				<xsl:text>0.0</xsl:text>
																			</xsl:when>
																			<xsl:when test="contains($rab_var, '.')=false">
																				<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																			</xsl:when>
																			<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																				<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="string($rab_var)"/>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:variable>
																	<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																	<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																	<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																</span>
															</td>
															<td style="text-align:right; ">
																<xsl:choose>
																	<xsl:when test="../@Decimals=3">
																		<xsl:for-each select="@MarketPrice2">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=4">
																		<xsl:for-each select="@MarketPrice2">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=5">
																		<xsl:for-each select="@MarketPrice2">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=6">
																		<xsl:for-each select="@MarketPrice2">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:for-each select="@MarketPrice2">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<td style="text-align:right; ">
																<span>
																	<xsl:variable name="rab_var" select="string(@MP2Volume)"/>
																	<xsl:variable name="rab_var1">
																		<xsl:choose>
																			<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																				<xsl:text>0.0</xsl:text>
																			</xsl:when>
																			<xsl:when test="contains($rab_var, '.')=false">
																				<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																			</xsl:when>
																			<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																				<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="string($rab_var)"/>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:variable>
																	<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																	<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																	<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																</span>
															</td>
															<td style="text-align:right; ">
																<xsl:choose>
																	<xsl:when test="../@Decimals=3">
																		<xsl:for-each select="@MarketPrice3">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=4">
																		<xsl:for-each select="@MarketPrice3">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=5">
																		<xsl:for-each select="@MarketPrice3">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=6">
																		<xsl:for-each select="@MarketPrice3">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:for-each select="@MarketPrice3">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<td style="text-align:right; ">
																<span>
																	<xsl:variable name="rab_var" select="string(@MP3Volume)"/>
																	<xsl:variable name="rab_var1">
																		<xsl:choose>
																			<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																				<xsl:text>0.0</xsl:text>
																			</xsl:when>
																			<xsl:when test="contains($rab_var, '.')=false">
																				<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																			</xsl:when>
																			<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																				<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="string($rab_var)"/>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:variable>
																	<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																	<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																	<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																</span>
															</td>
															<td style="text-align:right; ">
																<xsl:choose>
																	<xsl:when test="../@Decimals=3">
																		<xsl:for-each select="@ClearingPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=4">
																		<xsl:for-each select="@ClearingPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=5">
																		<xsl:for-each select="@ClearingPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:when test="../@Decimals=6">
																		<xsl:for-each select="@ClearingPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																		</xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:for-each select="@ClearingPrice">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
														</tr>
													</xsl:for-each>  <!-- RESULT -->
												</xsl:for-each>  <!-- SECURITY -->
											</tbody>
										</table>
										<br/>
									</xsl:for-each>  <!-- BOARD -->
									<xsl:for-each select="BOARD">
										<table width="100%" style="background=#FFFAF0; color=#191970; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0; border-top:0; font-family:Arial; font-size:9; word-wrap:break-word;" border="1">
											<thead style="text-align:center; word-wrap:break-word; ">
												<tr>
													<th colspan="16" style="text-align:center; font-size=12; font-weight:bold; background=#E6E6FA; color=#191970;">
														<xsl:value-of select="@BoardId"/>
														<xsl:text> - </xsl:text>
														<xsl:value-of select="@BoardName"/>
														<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
													</th>
												</tr>
												<tr>
													<th colspan="16" style="text-align:center; font-size=11; font-weight:bold; background=#E6E6FA; color=#191970;">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text> Статистика по кодам сроков расчетов и торговым периодам</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>Statistics on settlement period codes and trading periods</xsl:text>
															</xsl:when>
														</xsl:choose>
													</th>
												</tr>
												<tr style="text-align:center; vertical-align:top; word-wrap:break-word; color:#191970; background=#E6E6FA;">
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Тип договора</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Type of agreement</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Код срока расчетов</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Settlement period code</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Режим торгов</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Trading mode</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Торговый период</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Trading period</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Валюта цены</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Price currency</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Объем договоров в ц.б.</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Volume of contracts in securities</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Объем договоров в валюте инстр.</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Volume of contracts in curr. of instr.</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Кол-во договоров</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Number of contracts</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Перв. договор, цена в валюте инстр.</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Primary agreement, price in currency of instr.</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Перв. договор, объем</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Primary agreement, volume</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Посл. договор, цена в валюте инстр.</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Last agreement, price in currency of instr.</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Посл. договор, объем</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Last agreement, volume</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Последняя текущ. цена за период</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Last current price for period</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>MIN цена сделки за период</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>MIN deal price for period</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>MAX цена сделки за период</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>MAX deal price for period</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
													<th>
														<span style="font-weight:bold; text-align:center; ">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Средневзв. цена за период</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>weighted average price for period</xsl:text>
																</xsl:when>
															</xsl:choose>
														</span>
													</th>
												</tr>
											</thead>
											<tbody>
												<xsl:for-each select="SECURITY">
													<tr>
														<td colspan="16" style="font:10; font-weight:bold; text-align:left; vertical-align:middle; background= #CFCED9;">
															<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
															<xsl:value-of select="@SecurityId"/>
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>&#160;&#160;&#160;&#160;Краткое наименование ЦБ: </xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>&#160;&#160;&#160;&#160;Short name of the Security: </xsl:text>
																</xsl:when>
															</xsl:choose>
															<xsl:value-of select="@SecShortName"/>
															<xsl:text>&#160;(</xsl:text>
															<xsl:value-of select="@SecurityType"/>
															<xsl:text>)</xsl:text>
															<xsl:text>&#160;&#160;&#160;&#160;ISIN: </xsl:text>
															<xsl:value-of select="@ISIN"/>
															<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
															<xsl:value-of select="@RegNumber"/>
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>&#160;&#160;&#160;&#160;Эмитент: </xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>&#160;&#160;&#160;&#160;The Issuer: </xsl:text>
																</xsl:when>
															</xsl:choose>
															<xsl:value-of select="@IssuerName"/>
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>&#160;&#160;&#160;&#160;Котировальный лист: </xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>&#160;&#160;&#160;&#160;Quotation list: </xsl:text>
																</xsl:when>
															</xsl:choose>
															<xsl:value-of select="@QuoteList"/>
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>&#160;&#160;&#160;&#160;Номинал: </xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>&#160;&#160;&#160;&#160;Nominal value: </xsl:text>
																</xsl:when>
															</xsl:choose>
															<xsl:value-of select="@FaceValue"/>
															<xsl:text>&#160;</xsl:text>
															<xsl:value-of select="@SecCurrencyId"/>
															<xsl:choose>
																<xsl:when test="@CurrencyId='PCT'">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>&#160;&#160;&#160;&#160;НКД: </xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>&#160;&#160;&#160;&#160;Accumulated coupon income: </xsl:text>
																		</xsl:when>
																	</xsl:choose>
																	<xsl:for-each select="@AccruedInterest">
																		<xsl:value-of select="format-number(number(string(.)), '# ##0.00000000')"/>
																	</xsl:for-each>
																</xsl:when>
															</xsl:choose>
														</td>
													</tr>
													<xsl:for-each select="TRADE_PERIOD">
														<xsl:for-each select="MARKET_TRADE">
															<tr style="vertical-align:top;  background-color:#FFFFFF;">
																<td style="text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>рыночный</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>market</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</td>
																<td style="text-align:left; ">
																	<xsl:for-each select="@SettType">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:left; ">
																	<xsl:for-each select="@TradeMode">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:left; ">
																	<xsl:for-each select="../@TradePeriod">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../../@CurrencyId">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:right; width:auto; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@PeriodTotalAmount)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; width:auto; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@PeriodTotalVolume)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; ">
																	<xsl:for-each select="@PeriodTotalCount">
																		<xsl:value-of select="format-number(number(string(.)), '# ##0')"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@PeriodOpenPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@PeriodOpenPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@PeriodOpenPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@PeriodOpenPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@PeriodOpenPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@PeriodOpenVolume)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@PeriodLastPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@PeriodLastPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@PeriodLastPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@PeriodLastPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@PeriodLastPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@PeriodLastVolume)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@PeriodCurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@PeriodCurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@PeriodCurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@PeriodCurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@PeriodCurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; width:auto; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@PeriodMinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@PeriodMinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@PeriodMinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@PeriodMinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@PeriodMinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; width:auto; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@PeriodMaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@PeriodMaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@PeriodMaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@PeriodMaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@PeriodMaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@PeriodWAPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@PeriodWAPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@PeriodWAPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@PeriodWAPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@PeriodWAPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
															</tr>
														</xsl:for-each>  <!-- MARKET_TRADE -->
														<xsl:for-each select="ADDRESS_TRADE">
															<tr style="vertical-align:top;  background-color:#FFFFFF;">
																<td style="text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>адресный</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>addressable</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</td>
																<td style="text-align:left; ">
																	<xsl:for-each select="@SettType">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:left; ">
																	<xsl:for-each select="@TradeMode">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:left; ">
																	<xsl:for-each select="../@TradePeriod">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../../@CurrencyId">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:right; width:auto; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@AddressPeriodTotalAmount)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; width:auto; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@AddressPeriodTotalVolume)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; ">
																	<xsl:for-each select="@AddressPeriodTotalCount">
																		<xsl:value-of select="format-number(number(string(.)), '# ##0')"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@AddressPeriodOpenPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@AddressPeriodOpenPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@AddressPeriodOpenPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@AddressPeriodOpenPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@AddressPeriodOpenPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@AddressPeriodOpenVolume">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@AddressPeriodOpenVolume">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@AddressPeriodOpenVolume">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@AddressPeriodOpenVolume">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@AddressPeriodOpenVolume">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@AddressPeriodLastPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@AddressPeriodLastPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@AddressPeriodLastPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@AddressPeriodLastPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@AddressPeriodLastPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@AddressPeriodLastVolume)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@AddressPeriodCurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@AddressPeriodCurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@AddressPeriodCurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@AddressPeriodCurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@AddressPeriodCurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; width:auto; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@AddressPeriodMinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@AddressPeriodMinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@AddressPeriodMinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@AddressPeriodMinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@AddressPeriodMinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; width:auto; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@AddressPeriodMaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@AddressPeriodMaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@AddressPeriodMaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@AddressPeriodMaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@AddressPeriodMaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@AddressPeriodWAPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@AddressPeriodWAPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@AddressPeriodWAPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@AddressPeriodWAPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@AddressPeriodWAPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
															</tr>
														</xsl:for-each>  <!-- ADDRESS_TRADE -->
													</xsl:for-each>  <!-- TRADE_PERIOD -->
												</xsl:for-each>  <!-- SECURITY -->
											</tbody>
										</table>
										<br/>
									</xsl:for-each>  <!-- BOARD -->
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>  Другая версия отчета</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>  <!-- REPORT -->
					</xsl:for-each>  <!-- RTS_DOC -->
				</xsl:for-each>  <!-- $XML1 -->
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
