<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output version="4.0" method="html" indent="no" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:variable name="XML1" select="/"/>
	<xsl:decimal-format decimal-separator="," grouping-separator=" "/>
	<xsl:template match="/">
		<html>
			<head>
				<title/>
				<meta http-equiv="X-UA-Compatible" content="IE=5"/>
				<style type="text/css"/>
			</head>
			<body>
				<xsl:variable name="varlang" select="RTS_DOC/REPORT/DOC_INFO/@ReportLang"/>
				<xsl:variable name="varversion" select="RTS_DOC/REPORT/DOC_INFO/@ReportVersion"/>
				<xsl:for-each select="$XML1">
					<xsl:for-each select="RTS_DOC">
						<div>
							<xsl:for-each select="DOC_REQUISITES">
								<table width="100%" style="background-color:#FFFAF0; color=#191970; font-size:11; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0;" border="1">
									<xsl:variable name="CurrContextGrid_3" select="."/>
									<tr style="text-align:center; vertical-align:middle; word-wrap:break-word; font-size:15; font-weight:bold; color:#191970; background-color: #B0C4DE;">
										<th colspan="5">
											<span>
												<xsl:value-of select="@SENDER_NAME"/>
											</span>
										</th>
									</tr>
									<tr style="background-color:#E6E6FA; text-align:center;">
										<td width="27%">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Документ</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Document</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="7%">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Тип</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Type</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="15%">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код ЭДО отправителя</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Sender's EDI code</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код ЭДО получателя</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Recipient's EDI code</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td rowspan="2" style="font-style:italic; text-align:left; vertical-align:top; background-color:#FFFAF0;">
											<span style="font-weight:bold;">
												<xsl:choose>
													<xsl:when test="$varlang='RU'">
														<xsl:text>Примечание:</xsl:text>
													</xsl:when>
													<xsl:when test="$varlang='EN'">
														<xsl:text>Notes to the document:</xsl:text>
													</xsl:when>
												</xsl:choose>
											</span>
											<xsl:for-each select="@REMARKS">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
									</tr>
									<tr style="text-align:center">
										<td>
											<xsl:for-each select="@DOC_NO">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text> от </xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text> of </xsl:text>
												</xsl:when>
											</xsl:choose>
											<xsl:for-each select="@DOC_DATE">
												<xsl:variable name="seqContentStrings_0">
													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
													<xsl:text>-</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
													<xsl:text>-</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
												</xsl:variable>
												<xsl:variable name="sContent_0" select="string($seqContentStrings_0)"/>
												<xsl:value-of select="$sContent_0"/>
											</xsl:for-each>
											<xsl:text/>
											<xsl:for-each select="@DOC_TIME">
												<xsl:text> </xsl:text>
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="@DOC_TYPE_ID">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="@SENDER_ID">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="@RECEIVER_ID">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
							<!-- DOC_REQUISITES -->
						</div>
						<xsl:for-each select="REPORT">
							<xsl:for-each select="DOC_INFO">
								<table width="100%" style="background-color:#FFFAF0; color:#191970; font-size:11; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0;" border="1">
									<th colspan="5" style="text-align:center; vertical-align:middle; word-wrap:break-word; font-size:15; font-weight:bold; color:#191970; background= #B0C4DE;">
										<xsl:choose>
											<xsl:when test="@ReportDesc!=''">
												<span>
													<xsl:value-of select="@ReportDesc"/>
												</span>
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$varlang='RU'">
														<xsl:text>Биржевая информация об итогах Торгов за Торговый день</xsl:text>
													</xsl:when>
													<xsl:when test="$varlang='EN'">
														<xsl:text>Stock exchange information on trading results for the Trading Day</xsl:text>
													</xsl:when>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</th>
									<tr style="text-align:center;">
										<td colspan="2" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Дата отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report date:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report code:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Номер отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report number:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Том отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report volume:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
									</tr>
									<tr>
										<td colspan="2" style="text-align:center;">
											<xsl:for-each select="@ReportDate">
												<span>
													<xsl:variable name="seqContentStrings_1">
														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
														<xsl:text>-</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
														<xsl:text>-</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
													</xsl:variable>
													<xsl:variable name="sContent_1" select="string($seqContentStrings_1)"/>
													<xsl:value-of select="$sContent_1"/>
												</span>
											</xsl:for-each>
											<xsl:for-each select="@Weekday">
												<span>
													<xsl:text> (</xsl:text>
													<xsl:value-of select="string(.)"/>
													<xsl:text>)</xsl:text>
												</span>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@ReportCode">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@ReportNumber">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@Volume">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text> из </xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text> of </xsl:text>
												</xsl:when>
											</xsl:choose>
											<xsl:for-each select="@VolumeTotal">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
								<br/>
							</xsl:for-each>
							<!-- DOC_INFO -->
							<!--Проверка на версионность, и разветвление на разные типы отчетов -->
							<xsl:choose>
								<xsl:when test="$varversion=2">
									<xsl:for-each select="BOARD">
										<table width="100%" style="text-align:center; background=#FFFAF0; color=#191970; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0; border-top:0; font-family:Arial; font-size:9; word-wrap:break-word;" border="1">
											<tr>
												<th colspan="14" style="text-align:center; font-size:12; font-weight:bold; background-color:#FFFAF0; color=#191970;">
													<xsl:value-of select="@BoardId"/>
													<xsl:text> - </xsl:text>
													<xsl:value-of select="@BoardName"/>
												</th>
											</tr>
										</table>
										<xsl:for-each select="BASEASSETTYPE">
											<xsl:for-each select="BASEASSET">
												<xsl:for-each select="CONTRACT">
													<xsl:for-each select="OPTIONSERIES">
														<table width="100%" style="text-align:center; background=#FFFAF0; color=#191970; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0; border-top:0; font-family:Arial; font-size:9; word-wrap:break-word;" border="1">
															<tr style="text-align:center; font-size:12; font-weight:bold;">
																<th colspan="6" style="background-color:#E6E6FA;">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Базовый актив (БА)</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>The based asset (BA)</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</th>
																<th colspan="9" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Контракт</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Contract</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th colspan="3" style="background-color:#E6E6FA;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Опционная серия</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Optional series</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
															</tr>
															<tr style="text-align:center; vertical-align:top; word-wrap:break-word; color:#191970; background-color:#E6E6FA;">
																<th width="6%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Тип БА</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>BA type</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="6%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Тип идентиф. БА</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Type of BA identifier</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="6%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Идентиф. БА указанного типа</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>ID of specified type of BA</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="6%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Тикер БА</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Ticker BA</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="7%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Наименование БА</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Name of BA</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="7%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Группа инструментов, к которым относится БА</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Group of instruments that BA belongs to</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="4%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Тип исполнения</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Type of execution</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="7%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Признак маржируемого опциона</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>A sign of a margin option</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="6%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Признак поставочного опциона</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>he sign of a delivery option</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="5%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Количество единиц БА</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Number of units of BA</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="4%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Шаг цены</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Price step</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="4%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Стоимость шага цены</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Price step cost</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="4%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Стоимость пункта</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Point value</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="4%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Курс ЦБ на дату торгов</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>CB rate on trading date</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="4%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>ID валюты премии</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>ID of the award currency</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="7%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Дата начала обращения опционного договора</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Date of start of option agreement circulation</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="16%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Последний торговый день, в который может быть заключен опционный договор (контракт)</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Last trading day on which option agreement (contract) can be concluded</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="7%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Дата экcпирации опционной серии</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Option series expiration date</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
															</tr>
															<tr style="vertical-align:middle; background-color:#FFFAF0;">
																<td style="text-align:center; ">
																	<xsl:for-each select="../../../@BaseAssetType">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center;">
																	<xsl:for-each select="../../@BaseAssetDetailsType">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center;">
																	<xsl:for-each select="../../@BaseAssetDetails">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../../@BaseAssetCode">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../../@BaseAssetName">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../../@BaseAssetSection">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@ExecutionType">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@MarginType">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@DeliveryType">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@Lot">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@MinStep">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@StepPrice">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@PointRate">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@LocalCourse">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@CurrencyId">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="@TradeDateStart">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center;">
																	<xsl:for-each select="@TradeDateEnd">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center;">
																	<xsl:for-each select="@ExpirationDate">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
															</tr>
														</table>
														<table width="100%" style="border-bottom:0; border-collapse:collapse; border-left:0; border-right:0; border-top:0; font-family:Arial; font-size:9; word-wrap:break-word;" border="1">
															<tr style="text-align:center; vertical-align:top; word-wrap:break-word; color:#191970; background-color:#E6E6FA;">
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Торговый период</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Trading period</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Тип сделки</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Type of deal</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Объем сделок в контрактах</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Volume of deals in contracts</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Объем сделок в валюте инстр.</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Volume of deals in curr. of instr.</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Объем сделок в рублях</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Volume of deals in RUB</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Кол-во сделок</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Number of deals</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Объем последней сделки в контрактах</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Volume of last deal in contracts</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Цена последней сделки в валюте инстр.</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Price of Last deal in currency of instr.</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Цена последней сделки в рублях</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Price of Last deal in RUB</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Объем последней сделки в валюте инстр.</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Volume of Last deal in currency of instr.</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Объем последней сделки в рублях</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Volume of Last deal in RUB</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Дата заключения последнего договора</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Date of last contract conclusion</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Время заключения последнего договора</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>The time of last contract conclusion</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>MIN цена сделки за период</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>MIN deal price for period</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>MIN цена сделки за период в рублях</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>MIN deal price for period in RUB</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>MAX цена сделки за период</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>MAX deal price for period</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>MAX цена сделки за период в рублях</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>MAX deal price for period in RUB</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
															</tr>
															<xsl:for-each select="OPTION">
																<tr style="background-color:#FFFAF0; font-weight:bold; word-wrap:break-word;">
																	<th colspan="17" style="text-align:left;">
																		<span style="font-size:10pt;">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Опцион: </xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Option: </xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
																		</span>
																		<span style="font-size:10pt;">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Код</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Code</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text> = </xsl:text>
																			<xsl:value-of select="@OptionCode"/>
																			<xsl:text>;&#160;&#160;&#160;&#160;</xsl:text>
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Наименование</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Name</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text> = </xsl:text>
																			<xsl:value-of select="@OptionName"/>
																			<xsl:text>;&#160;&#160;&#160;&#160;</xsl:text>
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Тип (кол/пут)</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Type (qty/put)</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text> = </xsl:text>
																			<xsl:value-of select="@OptionType"/>
																			<xsl:text>;&#160;&#160;&#160;&#160;</xsl:text>
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Страйк опциона (в пунктах)</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Option strike (in points)</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text> = </xsl:text>
																			<xsl:choose>
																				<xsl:when test="@Strike">
																					<xsl:value-of select="format-number(number(@Strike), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																			<xsl:text>;&#160;&#160;&#160;&#160;</xsl:text>
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Валюта страйка</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>The currency of strike</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text> = </xsl:text>
																			<xsl:value-of select="@StrikeCurrency"/>
																			<xsl:text>;&#160;&#160;&#160;&#160;</xsl:text>
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Признак центрального страйка</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>The sign of a central strike</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text> = </xsl:text>
																			<xsl:value-of select="@IsCentralStrike"/>
																			<xsl:text>;</xsl:text>
																		</span>
																	</th>
																</tr>
																<xsl:for-each select="TRADE_PERIOD">
																	<xsl:for-each select="MARKET_TRADE">
																		<tr style="vertical-align:top;  background-color:#FFFFFF;">
																			<td style="text-align:left; ">
																				<xsl:value-of select="../@TradePeriod"/>
																			</td>
																			<td style="text-align:center; ">
																				<xsl:choose>
																					<xsl:when test="$varlang='RU'">
																						<xsl:text>рыночная</xsl:text>
																					</xsl:when>
																					<xsl:when test="$varlang='EN'">
																						<xsl:text>market</xsl:text>
																					</xsl:when>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@PeriodTotalAmount)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@PeriodTotalVolume)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<span>
																					<xsl:choose>
																						<xsl:when test="@PeriodTotalVolumeRub">
																							<xsl:variable name="rab_var" select="string(@PeriodTotalVolumeRub)"/>
																							<xsl:variable name="rab_var1">
																								<xsl:choose>
																									<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																										<xsl:text>0.0</xsl:text>
																									</xsl:when>
																									<xsl:when test="contains($rab_var, '.')=false">
																										<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																									</xsl:when>
																									<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																										<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:value-of select="string($rab_var)"/>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:variable>
																							<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																							<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																							<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																						</xsl:when>
																						<xsl:otherwise>0.00</xsl:otherwise>
																					</xsl:choose>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="format-number(number(@PeriodTotalCount), '# ##0')"/>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:choose>
																					<xsl:when test="@PeriodLastAmount">
																						<xsl:value-of select="format-number(number(@PeriodLastAmount), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="format-number(number(@PeriodLastPrice), '# ##0,00')"/>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:choose>
																					<xsl:when test="@PeriodLastPriceRub">
																						<xsl:value-of select="format-number(number(@PeriodLastPriceRub), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@PeriodLastVolume)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:choose>
																						<xsl:when test="@PeriodLastVolumeRub">
																							<xsl:variable name="rab_var" select="string(@PeriodLastVolumeRub)"/>
																							<xsl:variable name="rab_var1">
																								<xsl:choose>
																									<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																										<xsl:text>0.0</xsl:text>
																									</xsl:when>
																									<xsl:when test="contains($rab_var, '.')=false">
																										<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																									</xsl:when>
																									<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																										<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:value-of select="string($rab_var)"/>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:variable>
																							<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																							<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																							<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																						</xsl:when>
																						<xsl:otherwise>0.00</xsl:otherwise>
																					</xsl:choose>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="@PeriodLastDealDate"/>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="@PeriodLastDealTime"/>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@PeriodMinDealPrice">
																						<xsl:value-of select="format-number(number(@PeriodMinDealPrice), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@PeriodMinDealPriceRub">
																						<xsl:value-of select="format-number(number(@PeriodMinDealPriceRub), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@PeriodMaxDealPrice">
																						<xsl:value-of select="format-number(number(@PeriodMaxDealPrice), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@PeriodMaxDealPriceRub">
																						<xsl:value-of select="format-number(number(@PeriodMaxDealPriceRub), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																		</tr>
																	</xsl:for-each>  <!-- MARKET_TRADE -->
																	<xsl:for-each select="ADDRESS_TRADE">
																		<tr style="vertical-align:top;  background-color:#FFFFFF;">
																			<td style="text-align:left; ">
																				<xsl:value-of select="../@TradePeriod"/>
																			</td>
																			<td style="text-align:center; ">
																				<xsl:choose>
																					<xsl:when test="$varlang='RU'">
																						<xsl:text>адресная</xsl:text>
																					</xsl:when>
																					<xsl:when test="$varlang='EN'">
																						<xsl:text>addressable</xsl:text>
																					</xsl:when>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@AddressPeriodTotalAmount)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@AddressPeriodTotalVolume)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<span>
																					<xsl:choose>
																						<xsl:when test="@AddressPeriodTotalVolumeRub">
																							<xsl:variable name="rab_var" select="string(@AddressPeriodTotalVolumeRub)"/>
																							<xsl:variable name="rab_var1">
																								<xsl:choose>
																									<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																										<xsl:text>0.0</xsl:text>
																									</xsl:when>
																									<xsl:when test="contains($rab_var, '.')=false">
																										<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																									</xsl:when>
																									<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																										<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:value-of select="string($rab_var)"/>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:variable>
																							<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																							<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																							<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																						</xsl:when>
																						<xsl:otherwise>0.00</xsl:otherwise>
																					</xsl:choose>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="format-number(number(@AddressPeriodTotalCount), '# ##0')"/>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:choose>
																					<xsl:when test="@AddressPeriodLastAmount">
																						<xsl:value-of select="format-number(number(@AddressPeriodLastAmount), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="format-number(number(@AddressPeriodLastPrice), '# ##0,00')"/>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:choose>
																					<xsl:when test="@AddressPeriodLastPriceRub">
																						<xsl:value-of select="format-number(number(@AddressPeriodLastPriceRub), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@AddressPeriodLastVolume)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:choose>
																						<xsl:when test="@AddressPeriodLastVolumeRub">
																							<xsl:variable name="rab_var" select="string(@AddressPeriodLastVolumeRub)"/>
																							<xsl:variable name="rab_var1">
																								<xsl:choose>
																									<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																										<xsl:text>0.0</xsl:text>
																									</xsl:when>
																									<xsl:when test="contains($rab_var, '.')=false">
																										<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																									</xsl:when>
																									<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																										<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:value-of select="string($rab_var)"/>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:variable>
																							<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																							<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																							<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																						</xsl:when>
																						<xsl:otherwise>0.00</xsl:otherwise>
																					</xsl:choose>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="@AddressPeriodLastDealDate"/>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="@AddressPeriodLastDealTime"/>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@AddressPeriodMinDealPrice">
																						<xsl:value-of select="format-number(number(@AddressPeriodMinDealPrice), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@AddressPeriodMinDealPriceRub">
																						<xsl:value-of select="format-number(number(@AddressPeriodMinDealPriceRub), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@AddressPeriodMaxDealPrice">
																						<xsl:value-of select="format-number(number(@AddressPeriodMaxDealPrice), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@AddressPeriodMaxDealPriceRub">
																						<xsl:value-of select="format-number(number(@AddressPeriodMaxDealPriceRub), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																		</tr>
																	</xsl:for-each>  <!-- ADDRESS_TRADE -->
																</xsl:for-each>  <!-- TRADE_PERIOD -->
																<xsl:for-each select="RESULT">
																	<tr style="vertical-align:middle; font-size:11; font-weight:bold; background-color:#FFFFFF;">
																		<td colspan="2" style="text-align:right;">
																			<xsl:text>ВСЕГО:&#160;&#160;&#160;</xsl:text>
																			<!--<xsl:text>ВСЕГО по опциону &quot;</xsl:text>
																			<xsl:value-of select="../@OptionName"/>
																			<xsl:text>&quot; (</xsl:text>
																			<xsl:value-of select="../@OptionCode"/>
																			<xsl:text>):&#160;&#160;&#160;&#160;</xsl:text>-->
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<span>
																				<xsl:variable name="rab_var" select="string(@TotalAmount)"/>
																				<xsl:variable name="rab_var1">
																					<xsl:choose>
																						<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																							<xsl:text>0.0</xsl:text>
																						</xsl:when>
																						<xsl:when test="contains($rab_var, '.')=false">
																							<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																						</xsl:when>
																						<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																							<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																						</xsl:when>
																						<xsl:otherwise>
																							<xsl:value-of select="string($rab_var)"/>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:variable>
																				<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																				<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																				<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																			</span>
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<span>
																				<xsl:variable name="rab_var" select="string(@TotalVolume)"/>
																				<xsl:variable name="rab_var1">
																					<xsl:choose>
																						<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																							<xsl:text>0.0</xsl:text>
																						</xsl:when>
																						<xsl:when test="contains($rab_var, '.')=false">
																							<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																						</xsl:when>
																						<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																							<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																						</xsl:when>
																						<xsl:otherwise>
																							<xsl:value-of select="string($rab_var)"/>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:variable>
																				<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																				<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																				<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																			</span>
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<span>
																				<xsl:choose>
																					<xsl:when test="@TotalVolumeRub">
																						<xsl:variable name="rab_var" select="string(@TotalVolumeRub)"/>
																						<xsl:variable name="rab_var1">
																							<xsl:choose>
																								<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																									<xsl:text>0.0</xsl:text>
																								</xsl:when>
																								<xsl:when test="contains($rab_var, '.')=false">
																									<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																								</xsl:when>
																								<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																									<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																								</xsl:when>
																								<xsl:otherwise>
																									<xsl:value-of select="string($rab_var)"/>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:variable>
																						<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																						<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																						<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</span>
																		</td>
																		<td style="text-align:right; ">
																			<xsl:value-of select="format-number(number(@TotalDealCount), '# ##0')"/>
																		</td>
																		<td style="text-align:right; ">
																			<xsl:choose>
																				<xsl:when test="@LastDealAmount">
																					<xsl:value-of select="format-number(number(@LastDealAmount), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																		</td>
																		<td style="text-align:right; ">
																			<xsl:value-of select="format-number(number(@LastDealPrice), '# ##0,00')"/>
																		</td>
																		<td style="text-align:right; ">
																			<xsl:choose>
																				<xsl:when test="@LastDealPriceRub">
																					<xsl:value-of select="format-number(number(@LastDealPriceRub), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																		</td>
																		<td style="text-align:right; ">
																			<span>
																				<xsl:variable name="rab_var" select="string(@LastDealVolume)"/>
																				<xsl:variable name="rab_var1">
																					<xsl:choose>
																						<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																							<xsl:text>0.0</xsl:text>
																						</xsl:when>
																						<xsl:when test="contains($rab_var, '.')=false">
																							<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																						</xsl:when>
																						<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																							<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																						</xsl:when>
																						<xsl:otherwise>
																							<xsl:value-of select="string($rab_var)"/>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:variable>
																				<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																				<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																				<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																			</span>
																		</td>
																		<td style="text-align:right; ">
																			<span>
																				<xsl:choose>
																					<xsl:when test="@LastDealVolumeRub">
																						<xsl:variable name="rab_var" select="string(@LastDealVolumeRub)"/>
																						<xsl:variable name="rab_var1">
																							<xsl:choose>
																								<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																									<xsl:text>0.0</xsl:text>
																								</xsl:when>
																								<xsl:when test="contains($rab_var, '.')=false">
																									<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																								</xsl:when>
																								<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																									<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																								</xsl:when>
																								<xsl:otherwise>
																									<xsl:value-of select="string($rab_var)"/>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:variable>
																						<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																						<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																						<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</span>
																		</td>
																		<td style="text-align:right; ">
																			<xsl:value-of select="@LastDealDate"/>
																		</td>
																		<td style="text-align:right; ">
																			<xsl:value-of select="@LastDealTime"/>
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<xsl:choose>
																				<xsl:when test="@MinDealPrice">
																					<xsl:value-of select="format-number(number(@MinDealPrice), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<xsl:choose>
																				<xsl:when test="@MinDealPriceRub">
																					<xsl:value-of select="format-number(number(@MinDealPriceRub), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<xsl:choose>
																				<xsl:when test="@MaxDealPrice">
																					<xsl:value-of select="format-number(number(@MaxDealPrice), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<xsl:choose>
																				<xsl:when test="@MaxDealPriceRub">
																					<xsl:value-of select="format-number(number(@MaxDealPriceRub), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																		</td>
																	</tr>
																</xsl:for-each> <!-- RESULT -->
															</xsl:for-each> <!-- OPTION -->
														</table>
													</xsl:for-each> <!--OPTIONSERIES -->
												</xsl:for-each> <!-- CONTRACT -->
											</xsl:for-each> <!--BASEASSET -->
										</xsl:for-each> <!-- select="BASEASSETTYPE -->
										<br/>
									</xsl:for-each>  <!-- BOARD -->
								</xsl:when>
								<xsl:when test="$varversion=1">
									<xsl:for-each select="BOARD">
										<table width="100%" style="text-align:center; background=#FFFAF0; color=#191970; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0; border-top:0; font-family:Arial; font-size:9; word-wrap:break-word;" border="1">
											<tr>
												<th colspan="14" style="text-align:center; font-size:12; font-weight:bold; background-color:#FFFAF0; color=#191970;">
													<xsl:value-of select="@BoardId"/>
													<xsl:text> - </xsl:text>
													<xsl:value-of select="@BoardName"/>
												</th>
											</tr>
										</table>
										<xsl:for-each select="BASEASSETTYPE">
											<xsl:for-each select="BASEASSET">
												<xsl:for-each select="CONTRACT">
													<xsl:for-each select="OPTIONSERIES">
														<table width="100%" style="text-align:center; background=#FFFAF0; color=#191970; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0; border-top:0; font-family:Arial; font-size:9; word-wrap:break-word;" border="1">
															<tr style="text-align:center; font-size:12; font-weight:bold;">
																<th colspan="6" style="background-color:#E6E6FA;">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Базовый актив (БА)</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>The based asset (BA)</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</th>
																<th colspan="5" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Контракт</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Contract</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th colspan="3" style="background-color:#E6E6FA;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Опционная серия</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Optional series</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
															</tr>
															<tr style="text-align:center; vertical-align:top; word-wrap:break-word; color:#191970; background-color:#E6E6FA;">
																<th width="6%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Тип БА</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>BA type</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="6%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Тип идентификатора БА</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Type of BA identifier</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="6%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Идентификатор БА указанного типа</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>ID of specified type of BA</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="6%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Тикер БА</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Ticker BA</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="7%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Наименование БА</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Name of BA</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="7%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Группа инструментов, к которым относится БА</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Group of instruments that BA belongs to</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="4%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Тип исполнения</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Type of execution</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="7%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Признак маржируемого опциона</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>A sign of a margin option</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="6%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Признак поставочного опциона</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>he sign of a delivery option</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="5%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Количество единиц БА</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Number of units of BA</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="4%" style="background-color:#E6FFFF;">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>ID валюты премии</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>ID of the award currency</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="7%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Дата начала обращения опционного договора</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Date of start of option agreement circulation</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="16%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Последний торговый день, в который может быть заключен опционный договор (контракт)</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Last trading day on which option agreement (contract) can be concluded</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th width="7%">
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Дата экcпирации опционной серии</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Option series expiration date</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
															</tr>
															<tr style="vertical-align:middle; background-color:#FFFAF0;">
																<td style="text-align:center; ">
																	<xsl:for-each select="../../../@BaseAssetType">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center;">
																	<xsl:for-each select="../../@BaseAssetDetailsType">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center;">
																	<xsl:for-each select="../../@BaseAssetDetails">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../../@BaseAssetCode">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../../@BaseAssetName">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../../@BaseAssetSection">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@ExecutionType">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@MarginType">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@DeliveryType">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@Lot">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="../@CurrencyId">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="@TradeDateStart">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center;">
																	<xsl:for-each select="@TradeDateEnd">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:center;">
																	<xsl:for-each select="@ExpirationDate">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
															</tr>
														</table>
														<table width="100%" style="border-bottom:0; border-collapse:collapse; border-left:0; border-right:0; border-top:0; font-family:Arial; font-size:9; word-wrap:break-word;" border="1">
															<tr style="text-align:center; vertical-align:top; word-wrap:break-word; color:#191970; background-color:#E6E6FA;">
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Торговый период</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Trading period</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Тип сделки</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Type of deal</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Объем сделок в контрактах</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Volume of deals in contracts</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Объем сделок в валюте инстр.</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Volume of deals in curr. of instr.</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Объем сделок в рублях</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Volume of deals in RUB</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Кол-во сделок</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Number of deals</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Объем последней сделки в контрактах</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Volume of last deal in contracts</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Цена последней сделки в валюте инстр.</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Price of Last deal in currency of instr.</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Цена последней сделки в рублях</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Price of Last deal in RUB</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Объем последней сделки в валюте инстр.</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Volume of Last deal in currency of instr.</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Объем последней сделки в рублях</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Volume of Last deal in RUB</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Дата заключения последнего договора</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>Date of last contract conclusion</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>Время заключения последнего договора</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>The time of last contract conclusion</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>MIN цена сделки за период</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>MIN deal price for period</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>MIN цена сделки за период в рублях</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>MIN deal price for period in RUB</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>MAX цена сделки за период</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>MAX deal price for period</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
																<th>
																	<span style="font-weight:bold; text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>MAX цена сделки за период в рублях</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>MAX deal price for period in RUB</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</span>
																</th>
															</tr>
															<xsl:for-each select="OPTION">
																<tr style="background-color:#FFFAF0; font-weight:bold; word-wrap:break-word;">
																	<th colspan="17" style="text-align:left;">
																		<span style="font-size:10pt;">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Опцион: </xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Option: </xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
																		</span>
																		<span style="font-size:10pt;">
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Код</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Code</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text> = </xsl:text>
																			<xsl:value-of select="@OptionCode"/>
																			<xsl:text>;&#160;&#160;&#160;&#160;</xsl:text>
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Наименование</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Name</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text> = </xsl:text>
																			<xsl:value-of select="@OptionName"/>
																			<xsl:text>;&#160;&#160;&#160;&#160;</xsl:text>
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Тип (кол/пут)</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Type (qty/put)</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text> = </xsl:text>
																			<xsl:value-of select="@OptionType"/>
																			<xsl:text>;&#160;&#160;&#160;&#160;</xsl:text>
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Страйк опциона (в пунктах)</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>Option strike (in points)</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text> = </xsl:text>
																			<xsl:choose>
																				<xsl:when test="@Strike">
																					<xsl:value-of select="format-number(number(@Strike), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																			<xsl:text>;&#160;&#160;&#160;&#160;</xsl:text>
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Валюта страйка</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>The currency of strike</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text> = </xsl:text>
																			<xsl:value-of select="@StrikeCurrency"/>
																			<xsl:text>;&#160;&#160;&#160;&#160;</xsl:text>
																			<xsl:choose>
																				<xsl:when test="$varlang='RU'">
																					<xsl:text>Признак центрального страйка</xsl:text>
																				</xsl:when>
																				<xsl:when test="$varlang='EN'">
																					<xsl:text>The sign of a central strike</xsl:text>
																				</xsl:when>
																			</xsl:choose>
																			<xsl:text> = </xsl:text>
																			<xsl:value-of select="@IsCentralStrike"/>
																			<xsl:text>;</xsl:text>
																		</span>
																	</th>
																</tr>
																<xsl:for-each select="TRADE_PERIOD">
																	<xsl:for-each select="MARKET_TRADE">
																		<tr style="vertical-align:top;  background-color:#FFFFFF;">
																			<td style="text-align:left; ">
																				<xsl:value-of select="../@TradePeriod"/>
																			</td>
																			<td style="text-align:center; ">
																				<xsl:choose>
																					<xsl:when test="$varlang='RU'">
																						<xsl:text>рыночная</xsl:text>
																					</xsl:when>
																					<xsl:when test="$varlang='EN'">
																						<xsl:text>market</xsl:text>
																					</xsl:when>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@PeriodTotalAmount)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@PeriodTotalVolume)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<span>
																					<xsl:choose>
																						<xsl:when test="@PeriodTotalVolumeRub">
																							<xsl:variable name="rab_var" select="string(@PeriodTotalVolumeRub)"/>
																							<xsl:variable name="rab_var1">
																								<xsl:choose>
																									<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																										<xsl:text>0.0</xsl:text>
																									</xsl:when>
																									<xsl:when test="contains($rab_var, '.')=false">
																										<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																									</xsl:when>
																									<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																										<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:value-of select="string($rab_var)"/>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:variable>
																							<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																							<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																							<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																						</xsl:when>
																						<xsl:otherwise>0.00</xsl:otherwise>
																					</xsl:choose>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="format-number(number(@PeriodTotalCount), '# ##0')"/>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:choose>
																					<xsl:when test="@PeriodLastAmount">
																						<xsl:value-of select="format-number(number(@PeriodLastAmount), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="format-number(number(@PeriodLastPrice), '# ##0,00')"/>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:choose>
																					<xsl:when test="@PeriodLastPriceRub">
																						<xsl:value-of select="format-number(number(@PeriodLastPriceRub), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@PeriodLastVolume)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:choose>
																						<xsl:when test="@PeriodLastVolumeRub">
																							<xsl:variable name="rab_var" select="string(@PeriodLastVolumeRub)"/>
																							<xsl:variable name="rab_var1">
																								<xsl:choose>
																									<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																										<xsl:text>0.0</xsl:text>
																									</xsl:when>
																									<xsl:when test="contains($rab_var, '.')=false">
																										<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																									</xsl:when>
																									<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																										<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:value-of select="string($rab_var)"/>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:variable>
																							<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																							<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																							<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																						</xsl:when>
																						<xsl:otherwise>0.00</xsl:otherwise>
																					</xsl:choose>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="@PeriodLastDealDate"/>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="@PeriodLastDealTime"/>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@PeriodMinDealPrice">
																						<xsl:value-of select="format-number(number(@PeriodMinDealPrice), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@PeriodMinDealPriceRub">
																						<xsl:value-of select="format-number(number(@PeriodMinDealPriceRub), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@PeriodMaxDealPrice">
																						<xsl:value-of select="format-number(number(@PeriodMaxDealPrice), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@PeriodMaxDealPriceRub">
																						<xsl:value-of select="format-number(number(@PeriodMaxDealPriceRub), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																		</tr>
																	</xsl:for-each>  <!-- MARKET_TRADE -->
																	<xsl:for-each select="ADDRESS_TRADE">
																		<tr style="vertical-align:top;  background-color:#FFFFFF;">
																			<td style="text-align:left; ">
																				<xsl:value-of select="../@TradePeriod"/>
																			</td>
																			<td style="text-align:center; ">
																				<xsl:choose>
																					<xsl:when test="$varlang='RU'">
																						<xsl:text>адресная</xsl:text>
																					</xsl:when>
																					<xsl:when test="$varlang='EN'">
																						<xsl:text>addressable</xsl:text>
																					</xsl:when>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@AddressPeriodTotalAmount)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@AddressPeriodTotalVolume)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<span>
																					<xsl:choose>
																						<xsl:when test="@AddressPeriodTotalVolumeRub">
																							<xsl:variable name="rab_var" select="string(@AddressPeriodTotalVolumeRub)"/>
																							<xsl:variable name="rab_var1">
																								<xsl:choose>
																									<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																										<xsl:text>0.0</xsl:text>
																									</xsl:when>
																									<xsl:when test="contains($rab_var, '.')=false">
																										<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																									</xsl:when>
																									<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																										<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:value-of select="string($rab_var)"/>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:variable>
																							<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																							<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																							<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																						</xsl:when>
																						<xsl:otherwise>0.00</xsl:otherwise>
																					</xsl:choose>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="format-number(number(@AddressPeriodTotalCount), '# ##0')"/>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:choose>
																					<xsl:when test="@AddressPeriodLastAmount">
																						<xsl:value-of select="format-number(number(@AddressPeriodLastAmount), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="format-number(number(@AddressPeriodLastPrice), '# ##0,00')"/>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:choose>
																					<xsl:when test="@AddressPeriodLastPriceRub">
																						<xsl:value-of select="format-number(number(@AddressPeriodLastPriceRub), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:variable name="rab_var" select="string(@AddressPeriodLastVolume)"/>
																					<xsl:variable name="rab_var1">
																						<xsl:choose>
																							<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																								<xsl:text>0.0</xsl:text>
																							</xsl:when>
																							<xsl:when test="contains($rab_var, '.')=false">
																								<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																							</xsl:when>
																							<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																								<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="string($rab_var)"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:variable>
																					<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																					<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																					<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<span>
																					<xsl:choose>
																						<xsl:when test="@AddressPeriodLastVolumeRub">
																							<xsl:variable name="rab_var" select="string(@AddressPeriodLastVolumeRub)"/>
																							<xsl:variable name="rab_var1">
																								<xsl:choose>
																									<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																										<xsl:text>0.0</xsl:text>
																									</xsl:when>
																									<xsl:when test="contains($rab_var, '.')=false">
																										<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																									</xsl:when>
																									<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																										<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:value-of select="string($rab_var)"/>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:variable>
																							<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																							<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																							<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																						</xsl:when>
																						<xsl:otherwise>0.00</xsl:otherwise>
																					</xsl:choose>
																				</span>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="@AddressPeriodLastDealDate"/>
																			</td>
																			<td style="text-align:right; ">
																				<xsl:value-of select="@AddressPeriodLastDealTime"/>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@AddressPeriodMinDealPrice">
																						<xsl:value-of select="format-number(number(@AddressPeriodMinDealPrice), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@AddressPeriodMinDealPriceRub">
																						<xsl:value-of select="format-number(number(@AddressPeriodMinDealPriceRub), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@AddressPeriodMaxDealPrice">
																						<xsl:value-of select="format-number(number(@AddressPeriodMaxDealPrice), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																			<td style="text-align:right; width:auto; ">
																				<xsl:choose>
																					<xsl:when test="@AddressPeriodMaxDealPriceRub">
																						<xsl:value-of select="format-number(number(@AddressPeriodMaxDealPriceRub), '# ##0,00')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</td>
																		</tr>
																	</xsl:for-each>  <!-- ADDRESS_TRADE -->
																</xsl:for-each>  <!-- TRADE_PERIOD -->
																<xsl:for-each select="RESULT">
																	<tr style="vertical-align:middle; font-size:11; font-weight:bold; background-color:#FFFFFF;">
																		<td colspan="2" style="text-align:right;">
																			<xsl:text>ВСЕГО:&#160;&#160;&#160;</xsl:text>
																			<!--<xsl:text>ВСЕГО по опциону &quot;</xsl:text>
																			<xsl:value-of select="../@OptionName"/>
																			<xsl:text>&quot; (</xsl:text>
																			<xsl:value-of select="../@OptionCode"/>
																			<xsl:text>):&#160;&#160;&#160;&#160;</xsl:text>-->
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<span>
																				<xsl:variable name="rab_var" select="string(@TotalAmount)"/>
																				<xsl:variable name="rab_var1">
																					<xsl:choose>
																						<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																							<xsl:text>0.0</xsl:text>
																						</xsl:when>
																						<xsl:when test="contains($rab_var, '.')=false">
																							<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																						</xsl:when>
																						<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																							<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																						</xsl:when>
																						<xsl:otherwise>
																							<xsl:value-of select="string($rab_var)"/>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:variable>
																				<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																				<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																				<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																			</span>
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<span>
																				<xsl:variable name="rab_var" select="string(@TotalVolume)"/>
																				<xsl:variable name="rab_var1">
																					<xsl:choose>
																						<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																							<xsl:text>0.0</xsl:text>
																						</xsl:when>
																						<xsl:when test="contains($rab_var, '.')=false">
																							<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																						</xsl:when>
																						<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																							<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																						</xsl:when>
																						<xsl:otherwise>
																							<xsl:value-of select="string($rab_var)"/>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:variable>
																				<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																				<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																				<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																			</span>
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<span>
																				<xsl:choose>
																					<xsl:when test="@TotalVolumeRub">
																						<xsl:variable name="rab_var" select="string(@TotalVolumeRub)"/>
																						<xsl:variable name="rab_var1">
																							<xsl:choose>
																								<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																									<xsl:text>0.0</xsl:text>
																								</xsl:when>
																								<xsl:when test="contains($rab_var, '.')=false">
																									<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																								</xsl:when>
																								<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																									<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																								</xsl:when>
																								<xsl:otherwise>
																									<xsl:value-of select="string($rab_var)"/>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:variable>
																						<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																						<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																						<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</span>
																		</td>
																		<td style="text-align:right; ">
																			<xsl:value-of select="format-number(number(@TotalDealCount), '# ##0')"/>
																		</td>
																		<td style="text-align:right; ">
																			<xsl:choose>
																				<xsl:when test="@LastDealAmount">
																					<xsl:value-of select="format-number(number(@LastDealAmount), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																		</td>
																		<td style="text-align:right; ">
																			<xsl:value-of select="format-number(number(@LastDealPrice), '# ##0,00')"/>
																		</td>
																		<td style="text-align:right; ">
																			<xsl:choose>
																				<xsl:when test="@LastDealPriceRub">
																					<xsl:value-of select="format-number(number(@LastDealPriceRub), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																		</td>
																		<td style="text-align:right; ">
																			<span>
																				<xsl:variable name="rab_var" select="string(@LastDealVolume)"/>
																				<xsl:variable name="rab_var1">
																					<xsl:choose>
																						<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																							<xsl:text>0.0</xsl:text>
																						</xsl:when>
																						<xsl:when test="contains($rab_var, '.')=false">
																							<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																						</xsl:when>
																						<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																							<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																						</xsl:when>
																						<xsl:otherwise>
																							<xsl:value-of select="string($rab_var)"/>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:variable>
																				<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																				<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																				<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																			</span>
																		</td>
																		<td style="text-align:right; ">
																			<span>
																				<xsl:choose>
																					<xsl:when test="@LastDealVolumeRub">
																						<xsl:variable name="rab_var" select="string(@LastDealVolumeRub)"/>
																						<xsl:variable name="rab_var1">
																							<xsl:choose>
																								<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																									<xsl:text>0.0</xsl:text>
																								</xsl:when>
																								<xsl:when test="contains($rab_var, '.')=false">
																									<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																								</xsl:when>
																								<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																									<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																								</xsl:when>
																								<xsl:otherwise>
																									<xsl:value-of select="string($rab_var)"/>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:variable>
																						<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																						<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																						<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																					</xsl:when>
																					<xsl:otherwise>0.00</xsl:otherwise>
																				</xsl:choose>
																			</span>
																		</td>
																		<td style="text-align:right; ">
																			<xsl:value-of select="@LastDealDate"/>
																		</td>
																		<td style="text-align:right; ">
																			<xsl:value-of select="@LastDealTime"/>
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<xsl:choose>
																				<xsl:when test="@MinDealPrice">
																					<xsl:value-of select="format-number(number(@MinDealPrice), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<xsl:choose>
																				<xsl:when test="@MinDealPriceRub">
																					<xsl:value-of select="format-number(number(@MinDealPriceRub), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<xsl:choose>
																				<xsl:when test="@MaxDealPrice">
																					<xsl:value-of select="format-number(number(@MaxDealPrice), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																		</td>
																		<td style="text-align:right; width:auto; ">
																			<xsl:choose>
																				<xsl:when test="@MaxDealPriceRub">
																					<xsl:value-of select="format-number(number(@MaxDealPriceRub), '# ##0,00')"/>
																				</xsl:when>
																				<xsl:otherwise>0.00</xsl:otherwise>
																			</xsl:choose>
																		</td>
																	</tr>
																</xsl:for-each> <!-- RESULT -->
															</xsl:for-each> <!-- OPTION -->
														</table>
													</xsl:for-each> <!--OPTIONSERIES -->
												</xsl:for-each> <!-- CONTRACT -->
											</xsl:for-each> <!--BASEASSET -->
										</xsl:for-each> <!-- select="BASEASSETTYPE -->
										<br/>
									</xsl:for-each>  <!-- BOARD -->
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>  Другая версия отчета</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>  <!-- REPORT -->
					</xsl:for-each>  <!-- RTS_DOC -->
				</xsl:for-each>  <!-- $XML1 -->
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
