<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output version="4.0" method="html" indent="no" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:variable name="XML1" select="/"/>
	<xsl:decimal-format decimal-separator="," grouping-separator=" "/>
	<xsl:template match="/">
		<html>
			<head>
				<title/>
				<meta http-equiv="X-UA-Compatible" content="IE=5"/>
				<style type="text/css">
					@page { margin-left:0.6in;
					    margin-right:0.6in;
					    margin-top:0.79in;
					    margin-bottom:0.79in; }
					td { padding-top:1px;
					    padding-right:3px;
					    padding-bottom:1px;
					    padding-left:3px; }
					.t1 { font-size:8pt; }
					.h1 { background-color:#B0C4DE;
					    font-size:12pt;
					    font-weight:bold;
					    text-align:center; }
					.h2 { background-color:#FFFAF0;
					    font-size:10pt;
					    font-weight:bold;
					    text-align:center; }
					.h3 { background-color:#E6E6FA;
					    text-align:center;
					    vertical-align:top;
					    font-size:8pt;
					    font-weight:bold; }
					.h4 { background-color:#E6E6FA;
					    text-align:center;
					    vertical-align:top;
					    font-size:7pt;
					    font-weight:bold; }
					table { border-collapse:collapse;
					    border-bottom:0;
					    border-left:0;
					    border-top:0;
					    border-right:0;
					    background-color:#FFFAF0;
					    color:#191970;
					    font-size:7pt;
					    font-weight:400;
					    font-style:normal;
					    font-family:"Arial";
					    word-wrap:break-word; }
				</style>
			</head>
			<body>
				<xsl:variable name="varlang" select="RTS_DOC/REPORT/DOC_INFO/@ReportLang"/>
				<xsl:variable name="varversion" select="RTS_DOC/REPORT/DOC_INFO/@ReportVersion"/>
				<xsl:for-each select="$XML1">
				<xsl:for-each select="RTS_DOC">
					<div>
						<xsl:for-each select="DOC_REQUISITES">
							<table width="100%" style="background-color:#FFFAF0; color=#191970; font-size:11; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0;" border="1">
								<xsl:variable name="CurrContextGrid_3" select="."/>
								<tr style="text-align:center; vertical-align:middle; word-wrap:break-word; font-size:15; font-weight:bold; color:#191970; background-color: #B0C4DE;">
									<th colspan="5">
										<span>
											<xsl:value-of select="@SENDER_NAME"/>
										</span>
									</th>
								</tr>
								<tr style="background-color:#E6E6FA; text-align:center;">
									<td width="27%">
										<xsl:choose>
											<xsl:when test="$varlang='RU'">
												<xsl:text>Документ</xsl:text>
											</xsl:when>
											<xsl:when test="$varlang='EN'">
												<xsl:text>Document</xsl:text>
											</xsl:when>
										</xsl:choose>
									</td>
									<td width="7%">
										<xsl:choose>
											<xsl:when test="$varlang='RU'">
												<xsl:text>Тип</xsl:text>
											</xsl:when>
											<xsl:when test="$varlang='EN'">
												<xsl:text>Type</xsl:text>
											</xsl:when>
										</xsl:choose>
									</td>
									<td width="15%">
										<xsl:choose>
											<xsl:when test="$varlang='RU'">
												<xsl:text>Код ЭДО отправителя</xsl:text>
											</xsl:when>
											<xsl:when test="$varlang='EN'">
												<xsl:text>Sender's EDI code</xsl:text>
											</xsl:when>
										</xsl:choose>
									</td>
									<td>
										<xsl:choose>
											<xsl:when test="$varlang='RU'">
												<xsl:text>Код ЭДО получателя</xsl:text>
											</xsl:when>
											<xsl:when test="$varlang='EN'">
												<xsl:text>Recipient's EDI code</xsl:text>
											</xsl:when>
										</xsl:choose>
									</td>
									<td rowspan="2" style="font-style:italic; text-align:left; vertical-align:top; background-color:#FFFAF0;">
										<span style="font-weight:bold;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Примечание</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Notes to the document</xsl:text>
												</xsl:when>
											</xsl:choose>
										</span>
										<xsl:for-each select="@REMARKS">
											<xsl:value-of select="string(.)"/>
										</xsl:for-each>
									</td>
								</tr>
								<tr style="text-align:center">
									<td>
										<xsl:for-each select="@DOC_NO">
											<xsl:value-of select="string(.)"/>
										</xsl:for-each>
										<xsl:choose>
											<xsl:when test="$varlang='RU'">
												<xsl:text> от </xsl:text>
											</xsl:when>
											<xsl:when test="$varlang='EN'">
												<xsl:text> of </xsl:text>
											</xsl:when>
										</xsl:choose>
										<xsl:for-each select="@DOC_DATE">
											<xsl:variable name="seqContentStrings_0">
												<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
												<xsl:text>-</xsl:text>
												<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
												<xsl:text>-</xsl:text>
												<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
											</xsl:variable>
											<xsl:variable name="sContent_0" select="string($seqContentStrings_0)"/>
											<xsl:value-of select="$sContent_0"/>
										</xsl:for-each>
										<xsl:text> </xsl:text>
										<xsl:for-each select="@DOC_TIME">
											<xsl:text/>
											<xsl:value-of select="string(.)"/>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="@DOC_TYPE_ID">
											<xsl:value-of select="string(.)"/>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="@SENDER_ID">
											<xsl:value-of select="string(.)"/>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="@RECEIVER_ID">
											<xsl:value-of select="string(.)"/>
										</xsl:for-each>
									</td>
								</tr>
							</table>
						</xsl:for-each>
						<!-- DOC_REQUISITES -->
					</div>
					<xsl:for-each select="REPORT">
						<xsl:for-each select="DOC_INFO">
							<table width="100%" style="background-color:#FFFAF0; color:#191970; font-size:11; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0;" border="1">
								<th colspan="5" style="text-align:center; vertical-align:middle; word-wrap:break-word; font-size:15; font-weight:bold; color:#191970; background= #B0C4DE;">
									<xsl:choose>
										<xsl:when test="@ReportDesc!=''">
											<span>
												<xsl:value-of select="@ReportDesc"/>
											</span>
										</xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Биржевая информация об итогах Торгов ПФИ (фьючерсы) за торговый день до 19:00</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Exchange information on the trading results of PFI (futures) for the trading day before 19:00</xsl:text>
												</xsl:when>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
								</th>
								<tr style="text-align:center;">
									<td colspan="2" width="17%" style="background-color:#E6E6FA;">
										<xsl:choose>
											<xsl:when test="$varlang='RU'">
												<xsl:text>Дата отчета</xsl:text>
											</xsl:when>
											<xsl:when test="$varlang='EN'">
												<xsl:text>Report date</xsl:text>
											</xsl:when>
										</xsl:choose>
									</td>
									<td width="10%" style="background-color:#E6E6FA;">
										<xsl:choose>
											<xsl:when test="$varlang='RU'">
												<xsl:text>Код отчета</xsl:text>
											</xsl:when>
											<xsl:when test="$varlang='EN'">
												<xsl:text>Report code</xsl:text>
											</xsl:when>
										</xsl:choose>
									</td>
									<td width="10%" style="background-color:#E6E6FA;">
										<xsl:choose>
											<xsl:when test="$varlang='RU'">
												<xsl:text>Номер отчета</xsl:text>
											</xsl:when>
											<xsl:when test="$varlang='EN'">
												<xsl:text>Report number</xsl:text>
											</xsl:when>
										</xsl:choose>
									</td>
									<td width="10%" style="background-color:#E6E6FA;">
										<xsl:choose>
											<xsl:when test="$varlang='RU'">
												<xsl:text>Том отчета</xsl:text>
											</xsl:when>
											<xsl:when test="$varlang='EN'">
												<xsl:text>Report volume</xsl:text>
											</xsl:when>
										</xsl:choose>
									</td>
								</tr>
								<tr>
									<td colspan="2" style="text-align:center;">
										<xsl:for-each select="@ReportDate">
											<span>
												<xsl:variable name="seqContentStrings_1">
													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
													<xsl:text>-</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
													<xsl:text>-</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
												</xsl:variable>
												<xsl:variable name="sContent_1" select="string($seqContentStrings_1)"/>
												<xsl:value-of select="$sContent_1"/>
											</span>
										</xsl:for-each>
										<xsl:for-each select="@Weekday">
											<span>
												<xsl:text> (</xsl:text>
												<xsl:value-of select="string(.)"/>
												<xsl:text>)</xsl:text>
											</span>
										</xsl:for-each>
									</td>
									<td style="text-align:center;">
										<xsl:for-each select="@ReportCode">
											<xsl:value-of select="string(.)"/>
										</xsl:for-each>
									</td>
									<td style="text-align:center;">
										<xsl:for-each select="@ReportNumber">
											<xsl:value-of select="string(.)"/>
										</xsl:for-each>
									</td>
									<td style="text-align:center;">
										<xsl:for-each select="@Volume">
											<xsl:value-of select="string(.)"/>
										</xsl:for-each>
										<xsl:choose>
											<xsl:when test="$varlang='RU'">
												<xsl:text> из </xsl:text>
											</xsl:when>
											<xsl:when test="$varlang='EN'">
												<xsl:text> of </xsl:text>
											</xsl:when>
										</xsl:choose>
										<xsl:for-each select="@VolumeTotal">
											<xsl:value-of select="string(.)"/>
										</xsl:for-each>
									</td>
								</tr>
							</table>
							<br/>
						</xsl:for-each>	<!-- DOC_INFO -->
						<!--Проверка на версионность, и разветвление на разные типы отчетов -->
						<xsl:choose>
							<xsl:when test="$varversion=2">
								<xsl:for-each select="BOARD">
									<table width="100%" style="font-size:10pt;" border="1">
										<tr style="background-color:#E6E6FA; font-weight:bold; text-align:center; vertical-align:middle;">
											<td colspan="16">
												<xsl:value-of select="@BoardName"/>
												<xsl:text> (</xsl:text>
												<xsl:value-of select="@BoardId"/>
												<xsl:text>)</xsl:text>
											</td>
										</tr>
									</table>
									<xsl:for-each select="BASEASSETTYPE">
										<xsl:for-each select="BASEASSET">
											<table width="100%" style="font-size:10pt;" border="1">
												<tr style="background-color:#FFFAF0; text-align:center; vertical-align:middle;">
													<td width="8%" rowspan="2">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Базовый актив (БА):</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>Based asset (BA):</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="12%">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Тип базового актива (БА):</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>Type of based asset (BA):</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="12%">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Тип идентификатора БА</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>Type of BA ID</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="12%">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Идентификатор БА указанного типа</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>The ID of specified type of BA</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="12%">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Код БА</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>BA code</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="12%">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Наименование БА</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>BA name</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="12%">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Группа инструментов БА</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>BA tools group</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td rowspan="2" colspan="9">
														<xsl:text> </xsl:text>
													</td>
												</tr>
												<tr style="font-weight:bold; background-color:#FFFFFF; text-align:center; vertical-align:middle;">
													<td width="12%">
														<xsl:for-each select="../@BaseAssetType">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td width="12%">
														<xsl:for-each select="@BaseAssetDetailsType">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td width="12%">
														<xsl:for-each select="@BaseAssetDetails">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td width="12%">
														<xsl:for-each select="@BaseAssetCode">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td width="12%">
														<xsl:for-each select="@BaseAssetName">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td width="12%">
														<xsl:for-each select="@BaseAssetSection">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
												</tr>
											</table>
											<xsl:for-each select="FUTURES">
												<table width="100%" style="font-size:10pt;" border="1">
													<tr style="text-align:center; background-color:#FFFAD0; vertical-align:middle;">
														<td rowspan="2" width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Фьючерс</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Futures</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Код фьючерса</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Futures code</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Наименование фьючерса</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Futures name</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Тип контракта</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Type of contract</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Дата начала обращения фьючерсного договора</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Date of beginning of circulation of futures contract</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Последний торговый день, в который может быть заключен фьючерсный договор</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Last trading day on which a futures contract can be concluded</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Дата экcпирации</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Expiration date</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Дата исполнения</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Execution date</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Количество единиц БА</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Number of units of BA</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Шаг цены</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Price step</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Стоимость шага цены</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Cost of price step</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Торговый лот</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Trading lot</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Стоимость пункта</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Cost of point</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Курс ЦБ на дату торгов</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>CB rate on trading date</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Идентификатор валюты расчета/поставки</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>ID of payment/delivery currency</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Идентификатор валюты инструмента</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>ID of instrument's currency</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
													</tr>
													<tr style="font-weight:bold; background-color:#FFFFFF; text-align:center; vertical-align:middle;">
														<td width="6%">
															<xsl:for-each select="@FuturesCode">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:for-each select="@FuturesName">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:choose>
																		<xsl:when test="@DeliveryType='D'">
																			<xsl:text>поставочный</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																	<xsl:choose>
																		<xsl:when test="@DeliveryType='S'">
																			<xsl:text>расчетный</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:choose>
																		<xsl:when test="@DeliveryType='D'">
																			<xsl:text>delivery</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																	<xsl:choose>
																		<xsl:when test="@DeliveryType='S'">
																			<xsl:text>calculated</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="6%">
															<xsl:for-each select="@TradeDateStart">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:for-each select="@TradeDateEnd">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:for-each select="@ExpirationDate">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:for-each select="@ExecutionDate">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:for-each select="@Lot">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:for-each select="@MinStep">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:for-each select="@StepPrice">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:for-each select="@TradeLot">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:for-each select="@PointRate">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:for-each select="@LocalCourse">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:for-each select="@CurrencyId">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="6%">
															<xsl:for-each select="@CurrencyPriceId">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
													</tr>
												</table>
												<table width="100%" style="background=#FFFAF0; color=#191970; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0; border-top:0; font-family:Arial; font-size:11; word-wrap:break-word;" border="1">
													<thead style="text-align:center; word-wrap:break-word; ">
														<tr style="text-align:center; vertical-align:top; word-wrap:break-word; color:#191970; background-color:#E6E6FA; font-size:13;">
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Тип договора</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Type of agreement</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Торговый период</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Trading period</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Объем сделок в контрактах</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Volume of deals in contracts</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Объем сделок</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Volume of deals</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Кол-во сделок</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Number of deals</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Текущая цена</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Current price</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Объем последней сделки в контрактах</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Volume of last deal in contracts</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Цена последней сделки</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Price of last deal</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Объем последней сделки</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Volume of last deal</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Дата и время заключения последнего договора</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Date and time of last contract conclusion</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>MIN цена сделки за период</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>MIN deal price for period</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>MAX цена сделки за период</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>MAX deal price for period</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
														</tr>
													</thead>
													<tbody>
														<xsl:for-each select="TRADE_PERIOD">
															<xsl:for-each select="MARKET_TRADE">
																<tr style="vertical-align:top;  background-color:#FFFFFF;">
																	<td style="text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>рыночный</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>market</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</td>
																	<td style="text-align:center; ">
																		<xsl:for-each select="../@TradePeriod">
																			<xsl:value-of select="string(.)"/>
																		</xsl:for-each>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@PeriodTotalAmount)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@PeriodTotalVolume)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:right; ">
																		<xsl:for-each select="@PeriodTotalCount">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0')"/>
																		</xsl:for-each>
																	</td>
																	<td style="text-align:right; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@PeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@PeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@PeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@PeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@PeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td style="text-align:right; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@PeriodLastAmount)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:right; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@PeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@PeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@PeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@PeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@PeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td style="text-align:right; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@PeriodLastVolume)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:center; ">
																		<xsl:for-each select="@PeriodLastDealDate">
																			<xsl:value-of select="string(.)"/>
																		</xsl:for-each>
																		<xsl:text> </xsl:text>
																		<xsl:for-each select="@PeriodLastDealTime">
																			<xsl:value-of select="string(.)"/>
																		</xsl:for-each>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@PeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@PeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@PeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@PeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@PeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@PeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@PeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@PeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@PeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@PeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																</tr>
															</xsl:for-each>  <!-- MARKET_TRADE -->
															<xsl:for-each select="ADDRESS_TRADE">
																<tr style="vertical-align:top;  background-color:#FFFFFF;">
																	<td style="text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>адресный</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>addressable</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</td>
																	<td style="text-align:center; ">
																		<xsl:for-each select="../@TradePeriod">
																			<xsl:value-of select="string(.)"/>
																		</xsl:for-each>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@AddressPeriodTotalAmount)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@AddressPeriodTotalVolume)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:right; ">
																		<xsl:for-each select="@AddressPeriodTotalCount">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0')"/>
																		</xsl:for-each>
																	</td>
																	<td style="text-align:right; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@AddressPeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@AddressPeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@AddressPeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@AddressPeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@AddressPeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td style="text-align:right; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@AddressPeriodLastAmount)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:right; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@AddressPeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@AddressPeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@AddressPeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@AddressPeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@AddressPeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td style="text-align:right; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@AddressPeriodLastVolume)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:center; ">
																		<xsl:for-each select="@AddressPeriodLastDealDate">
																			<xsl:value-of select="string(.)"/>
																		</xsl:for-each>
																		<xsl:text> </xsl:text>
																		<xsl:for-each select="@AddressPeriodLastDealTime">
																			<xsl:value-of select="string(.)"/>
																		</xsl:for-each>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@AddressPeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@AddressPeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@AddressPeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@AddressPeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@AddressPeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@AddressPeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@AddressPeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@AddressPeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@AddressPeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@AddressPeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																</tr>
															</xsl:for-each>  <!-- ADDRESS_TRADE -->
														</xsl:for-each>  <!-- TRADE_PERIOD -->
														<xsl:for-each select="RESULT">
															<tr style="background-color:#FFFAF0; text-align:center; vertical-align:middle; font-weight:bold; font-size:13;">
																<td colspan="2">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>ВСЕГО:</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>IN TOTAL:</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</td>
																<td style="text-align:right; width:auto; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@TotalAmount)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; width:auto; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@TotalVolume)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; ">
																	<xsl:for-each select="@TotalDealCount">
																		<xsl:value-of select="format-number(number(string(.)), '# ##0')"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@CurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@CurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@CurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@CurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@CurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@LastDealAmount)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@LastDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@LastDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@LastDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@LastDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@LastDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@LastDealVolume)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="@LastDealDate">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																	<xsl:text> </xsl:text>
																	<xsl:for-each select="@LastDealTime">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:right; width:auto; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@MinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@MinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@MinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@MinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@MinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; width:auto; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@MaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@MaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@MaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@MaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@MaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
															</tr>
														</xsl:for-each> <!--RESULT -->
													</tbody>
												</table>
											</xsl:for-each> <!--FUTURES-->
										</xsl:for-each> <!--BASEASSET-->
									</xsl:for-each> <!--BASEASSETTYPE-->
									<br/>
								</xsl:for-each> <!--BOARD-->
							</xsl:when> <!--ReportVersion=2--> 
							<xsl:when test="$varversion=1">
								<xsl:for-each select="BOARD">
									<table width="100%" style="font-size:10pt;" border="1">
										<tr style="background-color:#E6E6FA; font-weight:bold; text-align:center; vertical-align:middle;">
											<td colspan="14">
												<xsl:value-of select="@BoardName"/>
												<xsl:text> (</xsl:text>
												<xsl:value-of select="@BoardId"/>
												<xsl:text>)</xsl:text>
											</td>
										</tr>
									</table>
									<xsl:for-each select="BASEASSETTYPE">
										<xsl:for-each select="BASEASSET">
											<table width="100%" style="font-size:10pt;" border="1">
												<tr style="background-color:#FFFAF0; text-align:center; vertical-align:middle;">
													<td width="8%" rowspan="2">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Базовый актив (БА):</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>Based asset (BA):</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="12%">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Тип базового актива (БА):</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>Type of based asset (BA):</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="12%">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Тип идентификатора БА:</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>Type of BA ID:</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="12%">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Идентификатор БА указанного типа:</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>The ID of specified type of BA:</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="12%">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Код БА:</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>BA code:</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="12%">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Наименование БА:</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>BA name:</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td width="12%">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:text>Группа инструментов БА:</xsl:text>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:text>BA tools group:</xsl:text>
															</xsl:when>
														</xsl:choose>
													</td>
													<td rowspan="2" colspan="7">
														<xsl:text> </xsl:text>
													</td>
												</tr>
												<tr style="font-weight:bold; background-color:#FFFFFF; text-align:center; vertical-align:middle;">
													<td width="12%">
														<xsl:for-each select="../@BaseAssetType">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td width="12%">
														<xsl:for-each select="@BaseAssetDetailsType">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td width="12%">
														<xsl:for-each select="@BaseAssetDetails">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td width="12%">
														<xsl:for-each select="@BaseAssetCode">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td width="12%">
														<xsl:for-each select="@BaseAssetName">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td width="12%">
														<xsl:for-each select="@BaseAssetSection">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
												</tr>
											</table>
											<xsl:for-each select="FUTURES">
												<table width="100%" style="font-size:10pt;" border="1">
													<tr style="text-align:center; background-color:#FFFAD0; vertical-align:middle;">
														<td rowspan="2" width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Фьючерс:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Futures:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Код фьючерса:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Futures code:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Наименование фьючерса:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Futures name:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Тип контракта:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Type of contract:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Дата начала обращения фьючерсного договора:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Date of beginning of circulation of futures contract:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Последний торговый день, в который может быть заключен фьючерсный договор:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Last trading day on which a futures contract can be concluded:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Дата экcпирации:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Expiration date:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Количество единиц БА:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Number of units of BA:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Шаг цены:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Price step:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Стоимость шага цены:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Cost of price step:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Торговый лот:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Trading lot:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Стоимость пункта:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>Cost of point:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Идентификатор валюты расчета/поставки:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>ID of payment/delivery currency:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:text>Идентификатор валюты инструмента:</xsl:text>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:text>ID of instrument's currency:</xsl:text>
																</xsl:when>
															</xsl:choose>
														</td>
													</tr>
													<tr style="font-weight:bold; background-color:#FFFFFF; text-align:center; vertical-align:middle;">
														<td width="8%">
															<xsl:for-each select="@FuturesCode">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="8%">
															<xsl:for-each select="@FuturesName">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="8%">
															<xsl:choose>
																<xsl:when test="$varlang='RU'">
																	<xsl:choose>
																		<xsl:when test="@DeliveryType='D'">
																			<xsl:text>поставочный</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																	<xsl:choose>
																		<xsl:when test="@DeliveryType='S'">
																			<xsl:text>расчетный</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</xsl:when>
																<xsl:when test="$varlang='EN'">
																	<xsl:choose>
																		<xsl:when test="@DeliveryType='D'">
																			<xsl:text>delivery</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																	<xsl:choose>
																		<xsl:when test="@DeliveryType='S'">
																			<xsl:text>calculated</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</xsl:when>
															</xsl:choose>
														</td>
														<td width="8%">
															<xsl:for-each select="@TradeDateStart">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="8%">
															<xsl:for-each select="@TradeDateEnd">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="8%">
															<xsl:for-each select="@ExpirationDate">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="8%">
															<xsl:for-each select="@Lot">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="8%">
															<xsl:for-each select="@MinStep">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="8%">
															<xsl:for-each select="@StepPrice">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="8%">
															<xsl:for-each select="@TradeLot">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="8%">
															<xsl:for-each select="@PointRate">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="8%">
															<xsl:for-each select="@CurrencyId">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
														<td width="8%">
															<xsl:for-each select="@CurrencyPriceId">
																<xsl:value-of select="string(.) "/>
															</xsl:for-each>
														</td>
													</tr>
												</table>
												<table width="100%" style="background=#FFFAF0; color=#191970; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0; border-top:0; font-family:Arial; font-size:11; word-wrap:break-word;" border="1">
													<thead style="text-align:center; word-wrap:break-word; ">
														<tr style="text-align:center; vertical-align:top; word-wrap:break-word; color:#191970; background-color:#E6E6FA; font-size:13;">
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Тип договора</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Type of agreement</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Торговый период</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Trading period</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Объем сделок в контрактах</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Volume of deals in contracts</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Объем сделок</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Volume of deals</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Кол-во сделок</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Number of deals</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Текущая цена</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Current price</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Объем последней сделки в контрактах</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Volume of last deal in contracts</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Цена последней сделки</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Price of last deal</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Объем последней сделки</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Volume of last deal</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>Дата и время заключения последнего договора</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Date and time of last contract conclusion</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>MIN цена сделки за период</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>MIN deal price for period</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
															<th>
																<span style="font-weight:bold; text-align:center; ">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>MAX цена сделки за период</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>MAX deal price for period</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</th>
														</tr>
													</thead>
													<tbody>
														<xsl:for-each select="TRADE_PERIOD">
															<xsl:for-each select="MARKET_TRADE">
																<tr style="vertical-align:top;  background-color:#FFFFFF;">
																	<td style="text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>рыночный</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>market</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</td>
																	<td style="text-align:center; ">
																		<xsl:for-each select="../@TradePeriod">
																			<xsl:value-of select="string(.)"/>
																		</xsl:for-each>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@PeriodTotalAmount)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@PeriodTotalVolume)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:right; ">
																		<xsl:for-each select="@PeriodTotalCount">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0')"/>
																		</xsl:for-each>
																	</td>
																	<td style="text-align:right; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@PeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@PeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@PeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@PeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@PeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td style="text-align:right; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@PeriodLastAmount)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:right; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@PeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@PeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@PeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@PeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@PeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td style="text-align:right; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@PeriodLastVolume)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:center; ">
																		<xsl:for-each select="@PeriodLastDealDate">
																			<xsl:value-of select="string(.)"/>
																		</xsl:for-each>
																		<xsl:text> </xsl:text>
																		<xsl:for-each select="@PeriodLastDealTime">
																			<xsl:value-of select="string(.)"/>
																		</xsl:for-each>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@PeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@PeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@PeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@PeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@PeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@PeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@PeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@PeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@PeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@PeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																</tr>
															</xsl:for-each>  <!-- MARKET_TRADE -->
															<xsl:for-each select="ADDRESS_TRADE">
																<tr style="vertical-align:top;  background-color:#FFFFFF;">
																	<td style="text-align:center; ">
																		<xsl:choose>
																			<xsl:when test="$varlang='RU'">
																				<xsl:text>адресный</xsl:text>
																			</xsl:when>
																			<xsl:when test="$varlang='EN'">
																				<xsl:text>addressable</xsl:text>
																			</xsl:when>
																		</xsl:choose>
																	</td>
																	<td style="text-align:center; ">
																		<xsl:for-each select="../@TradePeriod">
																			<xsl:value-of select="string(.)"/>
																		</xsl:for-each>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@AddressPeriodTotalAmount)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@AddressPeriodTotalVolume)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:right; ">
																		<xsl:for-each select="@AddressPeriodTotalCount">
																			<xsl:value-of select="format-number(number(string(.)), '# ##0')"/>
																		</xsl:for-each>
																	</td>
																	<td style="text-align:right; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@AddressPeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@AddressPeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@AddressPeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@AddressPeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@AddressPeriodCurrentPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td style="text-align:right; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@AddressPeriodLastAmount)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:right; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@AddressPeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@AddressPeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@AddressPeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@AddressPeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@AddressPeriodLastPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td style="text-align:right; ">
																		<span>
																			<xsl:variable name="rab_var" select="string(@AddressPeriodLastVolume)"/>
																			<xsl:variable name="rab_var1">
																				<xsl:choose>
																					<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																						<xsl:text>0.0</xsl:text>
																					</xsl:when>
																					<xsl:when test="contains($rab_var, '.')=false">
																						<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																					</xsl:when>
																					<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																						<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of select="string($rab_var)"/>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:variable>
																			<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																			<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																			<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																		</span>
																	</td>
																	<td style="text-align:center; ">
																		<xsl:for-each select="@AddressPeriodLastDealDate">
																			<xsl:value-of select="string(.)"/>
																		</xsl:for-each>
																		<xsl:text> </xsl:text>
																		<xsl:for-each select="@AddressPeriodLastDealTime">
																			<xsl:value-of select="string(.)"/>
																		</xsl:for-each>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@AddressPeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@AddressPeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@AddressPeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@AddressPeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@AddressPeriodMinDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td style="text-align:right; width:auto; ">
																		<xsl:choose>
																			<xsl:when test="../../@Decimals=3">
																				<xsl:for-each select="@AddressPeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=4">
																				<xsl:for-each select="@AddressPeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=5">
																				<xsl:for-each select="@AddressPeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:when test="../../@Decimals=6">
																				<xsl:for-each select="@AddressPeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																				</xsl:for-each>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:for-each select="@AddressPeriodMaxDealPrice">
																					<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																				</xsl:for-each>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																</tr>
															</xsl:for-each>  <!-- ADDRESS_TRADE -->
														</xsl:for-each>  <!-- TRADE_PERIOD -->
														<xsl:for-each select="RESULT">
															<tr style="background-color:#FFFAF0; text-align:center; vertical-align:middle; font-weight:bold; font-size:13;">
																<td colspan="2">
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>ВСЕГО:</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>IN TOTAL:</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</td>
																<td style="text-align:right; width:auto; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@TotalAmount)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; width:auto; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@TotalVolume)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; ">
																	<xsl:for-each select="@TotalDealCount">
																		<xsl:value-of select="format-number(number(string(.)), '# ##0')"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@CurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@CurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@CurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@CurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@CurrentPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@LastDealAmount)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:right; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@LastDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@LastDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@LastDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@LastDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@LastDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; ">
																	<span>
																		<xsl:variable name="rab_var" select="string(@LastDealVolume)"/>
																		<xsl:variable name="rab_var1">
																			<xsl:choose>
																				<xsl:when test="$rab_var='' or $rab_var='0' or $rab_var='0.' or $rab_var='.0'">
																					<xsl:text>0.0</xsl:text>
																				</xsl:when>
																				<xsl:when test="contains($rab_var, '.')=false">
																					<xsl:value-of select="string(concat($rab_var, '.0'))"/>
																				</xsl:when>
																				<xsl:when test="substring-before($rab_var, '.')='-' or substring-before($rab_var, '.')=''">
																					<xsl:value-of select="string(concat(substring-before($rab_var, '.'), '0.', substring-after($rab_var, '.')))"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="string($rab_var)"/>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:variable>
																		<xsl:if test="substring-before($rab_var1, '.')='-0'">-</xsl:if>
																		<xsl:value-of select="format-number(substring-before($rab_var1, '.'),'### ### ### ### ##0')"/>
																		<xsl:value-of select="format-number(concat('.', substring-after($rab_var1, '.'), '0'),',00######')"/>
																	</span>
																</td>
																<td style="text-align:center; ">
																	<xsl:for-each select="@LastDealDate">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																	<xsl:text> </xsl:text>
																	<xsl:for-each select="@LastDealTime">
																		<xsl:value-of select="string(.)"/>
																	</xsl:for-each>
																</td>
																<td style="text-align:right; width:auto; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@MinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@MinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@MinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@MinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@MinDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td style="text-align:right; width:auto; ">
																	<xsl:choose>
																		<xsl:when test="../../@Decimals=3">
																			<xsl:for-each select="@MaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=4">
																			<xsl:for-each select="@MaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,0000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=5">
																			<xsl:for-each select="@MaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:when test="../../@Decimals=6">
																			<xsl:for-each select="@MaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,000000')"/>
																			</xsl:for-each>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:for-each select="@MaxDealPrice">
																				<xsl:value-of select="format-number(number(string(.)), '# ##0,00')"/>
																			</xsl:for-each>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
															</tr>
														</xsl:for-each> <!--RESULT -->
													</tbody>
												</table>
											</xsl:for-each> <!--FUTURES-->
										</xsl:for-each> <!--BASEASSET-->
									</xsl:for-each> <!--BASEASSETTYPE-->
									<br/>
								</xsl:for-each> <!--BOARD-->
							</xsl:when> <!--ReportVersion=1--> 
							<xsl:otherwise>
								<xsl:text>Другая версия отчета</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each> <!--REPORT-->
				</xsl:for-each> <!--RTS_DOC-->
				</xsl:for-each> <!--XML1-->
			</body>
		</html>
	</xsl:template> 
</xsl:stylesheet>
