<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL"
	xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase"
	xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance"
	xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output version="4.0" method="html" indent="no" encoding="UTF-8"
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:variable name="XML1" select="/"/>
	<xsl:template match="/">
		<html>
			<head>
				<title/>
				<meta http-equiv="X-UA-Compatible" content="IE=5"/>
				<style>
					td {padding-top:1px;
					    padding-right:3px;
					    padding-bottom:1px;
					    padding-left:3px;
					    color:windowtext;
					    font-size:8pt;
					    font-weight:400;
					    font-style:normal;
					    text-decoration:none;
					    font-family:"Arial";
					    text-align:general;
					    vertical-align:bottom;
					    color:#191970;
					    word-wrap:break-word;}
				</style>
			</head>
			<body>
				<xsl:variable name="varlang" select="RTS_DOC/REPORT/DOC_INFO/@ReportLang"/>
				<xsl:variable name="varversion" select="RTS_DOC/REPORT/DOC_INFO/@ReportVersion"/>
				<xsl:for-each select="$XML1">
					<xsl:for-each select="RTS_DOC">
						<div>
							<xsl:for-each select="DOC_REQUISITES">
								<table width="100%" style="background-color:#FFFAF0; color=#191970; font-size:11; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0;" border="1">
									<xsl:variable name="CurrContextGrid_3" select="."/>
									<tr>
										<th colspan="5" style="text-align:center; vertical-align:Center; word-wrap:break-word; font-size:15; font-weight:bold; color:#191970; background-color: #B0C4DE;">
											<span>
												<xsl:value-of select="@SENDER_NAME"/>
											</span>
										</th>
									</tr>
									<tr style="background-color:#E6E6FA; text-align:center;">
										<td width="27%">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Документ</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Document</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="7%">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Тип</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Type</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="15%">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код ЭДО отправителя</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Sender's EDI code</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код ЭДО получателя</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Recipient's EDI code</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td rowspan="2" style="font-style:italic; text-align:left; vertical-align:top; background-color:#FFFAF0;">
											<span style="font-weight:bold;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Примечание:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Notes to the document:</xsl:text>
												</xsl:when>
											</xsl:choose>
											</span>
											<xsl:for-each select="@REMARKS">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
									</tr>
									<tr style="text-align:center">
										<td>
											<xsl:for-each select="@DOC_NO">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text> от </xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text> of </xsl:text>
												</xsl:when>
											</xsl:choose>
											<xsl:for-each select="@DOC_DATE">
												<xsl:variable name="seqContentStrings_0">
													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
													<xsl:text>-</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
													<xsl:text>-</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
												</xsl:variable>
												<xsl:variable name="sContent_0" select="string($seqContentStrings_0)"/>
												<xsl:value-of select="$sContent_0"/>
											</xsl:for-each>
											<xsl:text/>
											<xsl:for-each select="@DOC_TIME">
												<xsl:text> </xsl:text>
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="@DOC_TYPE_ID">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="@SENDER_ID">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="@RECEIVER_ID">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>  <!-- DOC_REQUISITES -->
						</div>
						<xsl:for-each select="REPORT">
							<xsl:for-each select="DOC_INFO">
								<table width="100%" style="background-color:#FFFAF0; color:#191970; font-size:11; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0;" border="1">
									<th colspan="5" style="text-align:center; vertical-align:Center; word-wrap:break-word; font-size:15; font-weight:bold; color:#191970; background= #B0C4DE;">
										<xsl:choose>
											<xsl:when test="@ReportDesc!=''">
												<span>
													<xsl:value-of select="@ReportDesc"/>
												</span>
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$varlang='RU'">
														<xsl:text>Уведомление о зарегистрированных кодах/кратких кодах клиентов Участника торгов и (или) Участника торгов</xsl:text>
													</xsl:when>
													<xsl:when test="$varlang='EN'">
														<xsl:text>Notification of registered codes/short codes of the Trading Members clients and/or of the Trading Memer</xsl:text>
													</xsl:when>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</th>
									<tr style="text-align:center;">
										<td width="17%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Дата отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report date:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="10%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Код отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report code:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="10%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Номер отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report number:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td width="10%" style="background-color:#E6E6FA;">
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text>Том отчета:</xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text>Report volume:</xsl:text>
												</xsl:when>
											</xsl:choose>
										</td>
										<td/>
									</tr>
									<tr>
										<td style="text-align:center;">
											<xsl:for-each select="@ReportDate">
												<span>
													<xsl:variable name="seqContentStrings_1">
														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
														<xsl:text>-</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
														<xsl:text>-</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
													</xsl:variable>
													<xsl:variable name="sContent_1" select="string($seqContentStrings_1)"/>
													<xsl:value-of select="$sContent_1"/>
												</span>
											</xsl:for-each>
											<xsl:for-each select="@Weekday">
												<span>
													<xsl:text> (</xsl:text>
													<xsl:value-of select="string(.)"/>
													<xsl:text>)</xsl:text>
												</span>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@ReportCode">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@ReportNumber">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td style="text-align:center;">
											<xsl:for-each select="@Volume">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
											<xsl:choose>
												<xsl:when test="$varlang='RU'">
													<xsl:text> из </xsl:text>
												</xsl:when>
												<xsl:when test="$varlang='EN'">
													<xsl:text> from </xsl:text>
												</xsl:when>
											</xsl:choose>
											<xsl:for-each select="@VolumeTotal">
												<xsl:value-of select="string(.)"/>
											</xsl:for-each>
										</td>
										<td/>
									</tr>
								</table>
								<br/>
							</xsl:for-each>  <!-- DOC_INFO -->
							<!-- Проверка на версионность, и разветвление на разные типы отчетов -->
							<xsl:choose>
								<xsl:when test="$varversion=1"> 
									<xsl:for-each select="FIRM">
										<table width="50%" style="background:#FFFAF0; color:#191970; word-wrap:break-word; border:0; border-bottom:0; border-collapse:collapse; border-left:0; border-right:0;" border="1">
											<tr>
												<td style="background-color:#E6E6FA; font-size:12;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Участник торгов:</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Trading Member:</xsl:text>
														</xsl:when>
													</xsl:choose>
												</td>
												<td style="font-weight:bold; font-size:12;">
													<xsl:for-each select="@FirmID">
														<xsl:value-of select="string(.)"/>
													</xsl:for-each>
												</td>
												<td style="background-color:#E6E6FA; font-size:12;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Наименование УТ:</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Trading Member name:</xsl:text>
														</xsl:when>
													</xsl:choose>
												</td>
												<td style="font-weight:bold; font-size:12;">
													<xsl:for-each select="@FirmName">
														<xsl:value-of select="string(.)"/>
													</xsl:for-each>
												</td>
											</tr>
										</table>
										<br/>
										<table width="100%"	style="background=#FFFAF0; color=#191970; border:1; border-bottom:0; 
												border-collapse:collapse; border-left:0; border-right:0; border-top:0; 
												font-family:Arial; font-size:9; word-wrap:break-word;" border="1">
											<tr style="text-align:center; vertical-align:top; word-wrap:break-word; color:#191970; background=#E6E6FA;">
												<th rowspan="2" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Краткий код</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Client Short Code</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th rowspan="2" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Признак лица, для которого зарегистрированы коды (учетный регистр)</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Identification of the person for whom codes are registered (register)</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th rowspan="2" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Тип клиента/УТ</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Client/Trading Member type</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th rowspan="2" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Реквизиты клиента/УТ</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Client details/Trading Member</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th rowspan="2" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Код страны</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Country code</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th rowspan="2" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Регистрационный код клиента (клиента второго уровня)/ УТ</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Registration code of the client (second-level client)/Trading Member</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th rowspan="2" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Операция с клиентом</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Operation with the client</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th rowspan="2" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Статус допуска клиента</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Client's admission status</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th colspan = "3" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Свойства клиента</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Property of client</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th colspan = "10" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Запреты на операции с инструментами</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Prohibitions on operations with securities</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>															
											</tr>
											<tr style="text-align:center;">
												<th rowspan="1" width="5%" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Квал. инвестор</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Qualified Investor</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th rowspan="1" width="5%" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text> ИИС </xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>IIA</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th rowspan="1" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Разрешен кросс-маркет</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>cross-market transactions are allowed</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th rowspan="1" width="5%" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>ИЦБ</xsl:text><br/>
															<xsl:text>Акции треб. тестирования</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Foreign Securities Req. testing</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>										
												<th rowspan="1" width="5%" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>ИЦБ</xsl:text><br/>
															<xsl:text>ETF треб. тестирования</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Foreign Securities ETF testing required</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>	
												<th rowspan="1" width="5%" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>РЦБ</xsl:text><br/>
															<xsl:text>Бумаги вне списков</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Russian Securities Unlisted papersDerivatives</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>	
												<th rowspan="1" width="5%" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>ПФИ</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Derivatives</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>	
												<th rowspan="1" width="5%" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>РЦБ</xsl:text><br/>
															<xsl:text>Облигации эмитентов без рейтинга</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Russian Bonds of issuers without rating</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th rowspan="1" width="5%" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>ИЦБ</xsl:text><br/>
															<xsl:text>Облигации эмитентов без рейтинга</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Foreign Bonds of issuers without rating</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>
												<th rowspan="1" width="5%" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Структурные облигации</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Structured bonds</xsl:text>
														</xsl:when>
													</xsl:choose>
													<xsl:text></xsl:text>
												</th>	
												<th rowspan="1" width="5%" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>Облигации со структ. доходом</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>Bonds with structured income</xsl:text>
														</xsl:when>
													</xsl:choose>
													<xsl:text></xsl:text>
												</th>	
												<th rowspan="1" width="5%" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>РЕПО</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>REPO</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>	
												<th rowspan="1" width="5%" style="background-color:#FFFAF0; text-align:center; vertical-align:center;">
													<xsl:choose>
														<xsl:when test="$varlang='RU'">
															<xsl:text>ЗПИФ</xsl:text>
														</xsl:when>
														<xsl:when test="$varlang='EN'">
															<xsl:text>closed-end investment fund</xsl:text>
														</xsl:when>
													</xsl:choose>
												</th>																
											</tr>
											<xsl:for-each select="RECORDS">
												<xsl:sort select="@Status"/>
												<tr style="vertical-align:top; ">
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:for-each select="@ClientCode">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@Principal='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>УТ</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Trading Member</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:when test="@Principal='N'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>клиент УТ</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Trading Member client</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:for-each select="@Type">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:for-each select="@Details">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:for-each select="@CountryCode">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:for-each select="@RegulatorCode">
															<xsl:value-of select="string(.) "/>
														</xsl:for-each>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:choose>
																	<xsl:when test="@Status='A'">
																		<span>
																			<xsl:text>зарегистр.</xsl:text>
																		</span>
																	</xsl:when>
																	<xsl:when test="@Status='U'">
																		<span>
																			<xsl:text>обновлен</xsl:text>
																		</span>
																	</xsl:when>
																	<xsl:when test="@Status='D'">
																		<span>
																			<xsl:text>удален</xsl:text>
																		</span>
																	</xsl:when>
																	<xsl:otherwise>
																		<span>
																			<xsl:text></xsl:text>
																		</span>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:choose>
																	<xsl:when test="@Status='A'">
																		<span>
																			<xsl:text>registered</xsl:text>
																		</span>
																	</xsl:when>
																	<xsl:when test="@Status='U'">
																		<span>
																			<xsl:text>updated</xsl:text>
																		</span>
																	</xsl:when>
																	<xsl:when test="@Status='D'">
																		<span>
																			<xsl:text>deleted</xsl:text>
																		</span>
																	</xsl:when>
																	<xsl:otherwise>
																		<span>
																			<xsl:text></xsl:text>
																		</span>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:when>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="$varlang='RU'">
																<xsl:choose>
																	<xsl:when test="@AccessStatus='A'">
																		<span>
																			<xsl:text>допущен</xsl:text>
																		</span>
																	</xsl:when>
																	<xsl:when test="@AccessStatus='N' or @Status='n'">
																		<span>
																			<xsl:text>допуск приостановлен</xsl:text>
																		</span>
																	</xsl:when>
																	<xsl:when test="@AccessStatus='D' or @Status='d'">
																		<span>
																			<xsl:text>допуск прекращен</xsl:text>
																		</span>
																	</xsl:when>
																	<xsl:otherwise>
																		<span>
																			<xsl:text></xsl:text>
																		</span>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:when>
															<xsl:when test="$varlang='EN'">
																<xsl:choose>
																	<xsl:when test="@AccessStatus='A'">
																		<span>
																			<xsl:text>admitted</xsl:text>
																		</span>
																	</xsl:when>
																	<xsl:when test="@AccessStatus='N' or @Status='n'">
																		<span>
																			<xsl:text>suspension of registration</xsl:text>
																		</span>
																	</xsl:when>
																	<xsl:when test="@AccessStatus='D' or @Status='d'">
																		<span>
																			<xsl:text>admission terminated</xsl:text>
																		</span>
																	</xsl:when>
																	<xsl:otherwise>
																		<span>
																			<xsl:text></xsl:text>
																		</span>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:when>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@Q_Investor='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>квал.</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>Qualified Investor</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text/>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@IndividualInvestmentAccount='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>ИИС</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>IIA</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text/>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@CheckCrossMarket='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>разрешен</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>allowed</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text></xsl:text>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<!-- Новые поля -->
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@ForeignSecurityClientProhibition='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>запрет</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>prohibition</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text></xsl:text>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@ForeignETFClientProhibition='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>запрет</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>prohibition</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text></xsl:text>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@UnquotRuSecurityClientProhibition='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>запрет</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>prohibition</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text></xsl:text>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@DerivativesClientProhibition='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>запрет</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>prohibition</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text></xsl:text>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@UnratedRuBondClientProhibition='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>запрет</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>prohibition</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text></xsl:text>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@ForeignBondClientProhibition='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>запрет</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>prohibition</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text></xsl:text>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@StructuredBondClientProhibition='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>запрет</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>prohibition</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text></xsl:text>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@StructuredIncomeBondClientProhibition='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>запрет</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>prohibition</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text></xsl:text>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@RepoClientProhibition='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>запрет</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>prohibition</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text></xsl:text>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<td style="border-bottom:1; border-top:0; text-align:center; ">
														<xsl:choose>
															<xsl:when test="@ClosedFundClientProhibition='Y'">
																<span>
																	<xsl:choose>
																		<xsl:when test="$varlang='RU'">
																			<xsl:text>запрет</xsl:text>
																		</xsl:when>
																		<xsl:when test="$varlang='EN'">
																			<xsl:text>prohibition</xsl:text>
																		</xsl:when>
																	</xsl:choose>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<span>
																	<xsl:text></xsl:text>
																</span>
															</xsl:otherwise>
														</xsl:choose>
													</td>
												</tr>
											</xsl:for-each>  <!-- RECORDS -->
										</table>
										<br/>
									</xsl:for-each>  <!-- FIRM -->
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>  Другая версия отчета</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>  <!-- REPORT -->
					</xsl:for-each>  <!-- RTS_DOC -->
				</xsl:for-each>  <!-- $XML1 -->
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
